/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.ArrayList;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.debug.DynamicCounterNode;
import org.graalvm.compiler.nodes.debug.WeakCounterNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.EscapeObjectState;
import org.graalvm.compiler.nodes.virtual.VirtualObjectState;
import org.graalvm.compiler.virtual.phases.ea.EffectList;

public final class GraphEffectList
extends EffectList {
    private int virtualizationDelta;
    private int allocationNodeDelta;

    public GraphEffectList(DebugContext debug) {
        super(debug);
    }

    @Override
    public void clear() {
        super.clear();
        this.virtualizationDelta = 0;
        this.allocationNodeDelta = 0;
    }

    public void addCounterBefore(final String group, final String name, final int increment, final boolean addContext, final FixedNode position) {
        this.add(new EffectList.SimpleEffect("add counter"){

            @Override
            public void apply(StructuredGraph graph) {
                DynamicCounterNode.addCounterBefore(group, name, increment, addContext, position);
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"group", "name", "increment", "addContext", "position"}, new Object[]{group, name, increment, addContext, position});
            }
        });
    }

    public void addCounterAfter(final String group, final String name, final int increment, final boolean addContext, final FixedWithNextNode position) {
        final FixedNode nextPosition = position.next();
        this.add(new EffectList.SimpleEffect("add counter after"){

            @Override
            public void apply(StructuredGraph graph) {
                DynamicCounterNode.addCounterBefore(group, name, increment, addContext, nextPosition);
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"group", "name", "increment", "addContext", "position"}, new Object[]{group, name, increment, addContext, position});
            }
        });
    }

    public void addWeakCounterCounterBefore(final String group, final String name, final int increment, final boolean addContext, final ValueNode checkedValue, final FixedNode position) {
        this.add(new EffectList.SimpleEffect("add weak counter"){

            @Override
            public void apply(StructuredGraph graph) {
                WeakCounterNode.addCounterBefore(group, name, increment, addContext, checkedValue, position);
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"group", "name", "increment", "addContext", "position"}, new Object[]{group, name, increment, addContext, position});
            }
        });
    }

    public void addFixedNodeBefore(final FixedWithNextNode node, final FixedNode position) {
        this.add(new EffectList.SimpleEffect("add fixed node"){

            @Override
            public void apply(StructuredGraph graph) {
                assert (!node.isAlive() && !node.isDeleted() && position.isAlive());
                graph.addBeforeFixed(position, graph.add(node));
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "position"}, new Object[]{node, position});
            }
        });
    }

    void ensureAdded(final ValueNode node, final FixedNode position) {
        assert (!(node instanceof FixedWithNextNode) || position != null);
        this.add(new EffectList.SimpleEffect("ensure added"){

            @Override
            public void apply(StructuredGraph graph) {
                assert (position == null || position.isAlive());
                if (!node.isAlive()) {
                    graph.addWithoutUniqueWithInputs(node);
                    if (node instanceof FixedWithNextNode) {
                        graph.addBeforeFixed(position, (FixedWithNextNode)node);
                    }
                }
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "position"}, new Object[]{node, position});
            }
        });
    }

    public void addVirtualizationDelta(int delta) {
        this.virtualizationDelta += delta;
    }

    public int getVirtualizationDelta() {
        return this.virtualizationDelta;
    }

    public void addAllocationDelta(int delta) {
        this.allocationNodeDelta += delta;
    }

    public int getAllocationDelta() {
        return this.allocationNodeDelta;
    }

    public void addFloatingNode(final ValueNode node, final String cause) {
        this.add(new EffectList.SimpleEffect("add floating node"){

            @Override
            public void apply(StructuredGraph graph) {
                GraalError.guarantee(node.isUnregistered(), cause);
                assert (!node.isAlive() && !node.isDeleted());
                graph.addWithoutUniqueWithInputs(node);
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "cause"}, new Object[]{node, cause});
            }
        });
    }

    void ensureFloatingAdded(ValueNode node) {
        this.ensureAdded(node, null);
    }

    public void initializePhiInput(final PhiNode node, final int index, final ValueNode value) {
        this.add(new EffectList.Effect("set phi input"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                assert (node.isAlive() && index >= 0) : node;
                node.initializeValueAt(index, graph.addOrUniqueWithInputs(value));
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "index", "value"}, new Object[]{node, index, value});
            }
        });
    }

    public void addVirtualMapping(final FrameState node, final EscapeObjectState state) {
        this.add(new EffectList.Effect("add virtual mapping"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (node.isAlive()) {
                    assert (!state.isDeleted());
                    FrameState stateAfter = node;
                    for (int i = 0; i < stateAfter.virtualObjectMappingCount(); ++i) {
                        if (stateAfter.virtualObjectMappingAt(i).object() != state.object()) continue;
                        stateAfter.virtualObjectMappings().remove(i);
                    }
                    stateAfter.addVirtualObjectMapping(graph.addOrUniqueWithInputs(state));
                }
            }

            @Override
            public boolean isVisible() {
                return false;
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "state"}, new Object[]{node, state});
            }
        });
    }

    public void updateVirtualMapping(final VirtualObjectState state, final int field, final ValueNode newValue) {
        this.add(new EffectList.Effect("add virtual mapping"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (state.isAlive()) {
                    state.values().set(field, (Object)graph.addOrUniqueWithInputs(newValue));
                }
            }

            @Override
            public boolean isVisible() {
                return false;
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"state", "field", "newValue"}, new Object[]{state, field, newValue});
            }
        });
    }

    public void deleteNode(final Node node) {
        this.add(new EffectList.Effect("delete fixed node"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (node instanceof FixedWithNextNode) {
                    GraphUtil.unlinkFixedNode((FixedWithNextNode)node);
                } else if (node instanceof WithExceptionNode && node.isAlive()) {
                    WithExceptionNode withExceptionNode = (WithExceptionNode)node;
                    AbstractBeginNode next = withExceptionNode.next();
                    GraphUtil.unlinkAndKillExceptionEdge(withExceptionNode);
                    if (next.hasNoUsages() && MemoryKill.isMemoryKill(next)) {
                        graph.replaceFixedWithFixed(next, graph.add(new BeginNode()));
                    }
                    obsoleteNodes.add(withExceptionNode);
                }
                obsoleteNodes.add(node);
            }

            @Override
            public boolean isCfgKill() {
                return node instanceof WithExceptionNode;
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node"}, new Object[]{node});
            }
        });
    }

    public void killIfBranch(final IfNode ifNode, final boolean constantCondition) {
        this.add(new EffectList.Effect("kill if branch"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (ifNode.isAlive()) {
                    graph.removeSplitPropagate(ifNode, ifNode.getSuccessor(constantCondition));
                }
            }

            @Override
            public boolean isCfgKill() {
                return true;
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"ifNode", "constantCondition"}, new Object[]{ifNode, constantCondition});
            }
        });
    }

    public void replaceWithSink(final FixedWithNextNode node, final ControlSinkNode sink) {
        this.add(new EffectList.Effect("replace with sink"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                try (DebugCloseable position = graph.withNodeSourcePosition(node);){
                    graph.addWithoutUnique(sink);
                    node.replaceAtPredecessor(sink);
                    GraphUtil.killCFG(node);
                }
            }

            @Override
            public boolean isCfgKill() {
                return true;
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "sink"}, new Object[]{node, sink});
            }
        });
    }

    public void replaceAtUsages(final ValueNode node, final ValueNode replacement, final FixedNode insertBefore) {
        assert (node != null && replacement != null) : node + " " + replacement;
        assert (!node.hasUsages() || node.stamp(NodeView.DEFAULT).isCompatible(replacement.stamp(NodeView.DEFAULT))) : "Replacement node stamp not compatible " + node.stamp(NodeView.DEFAULT) + " vs " + replacement.stamp(NodeView.DEFAULT);
        this.add(new EffectList.Effect("replace at usages"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                try (DebugCloseable position = graph.withNodeSourcePosition(node);){
                    assert (node.isAlive());
                    ValueNode replacementNode = graph.addOrUniqueWithInputs(replacement);
                    assert (replacementNode.isAlive());
                    assert (insertBefore != null);
                    if (replacementNode instanceof FixedWithNextNode && ((FixedWithNextNode)replacementNode).next() == null) {
                        graph.addBeforeFixed(insertBefore, (FixedWithNextNode)replacementNode);
                    }
                    if (node.hasUsages() && !node.stamp(NodeView.DEFAULT).equals(replacementNode.stamp(NodeView.DEFAULT))) {
                        replacementNode = graph.unique(new PiNode(replacementNode, node.stamp(NodeView.DEFAULT)));
                    }
                    node.replaceAtUsages(replacementNode);
                    if (node instanceof FixedWithNextNode) {
                        GraphUtil.unlinkFixedNode((FixedWithNextNode)node);
                    }
                    obsoleteNodes.add(node);
                }
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "replacement", "insertBefore"}, new Object[]{node, replacement, insertBefore});
            }
        });
    }

    public void replaceFirstInput(final Node node, final Node oldInput, final Node newInput) {
        assert (node.isAlive() && oldInput.isAlive() && !newInput.isDeleted());
        this.add(new EffectList.Effect("replace first input"){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (node.isAlive()) {
                    assert (oldInput.isAlive() && newInput.isAlive());
                    node.replaceFirstInput(oldInput, newInput);
                }
            }

            @Override
            public boolean isVisible() {
                return !(node instanceof FrameState);
            }

            @Override
            void format(StringBuilder str) {
                this.format(str, new String[]{"node", "oldInput", "newInput"}, new Object[]{node, oldInput, newInput});
            }
        });
    }
}

