/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.Optional;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;
import org.graalvm.compiler.virtual.phases.ea.VirtualUtil;

public class FinalPartialEscapePhase
extends PartialEscapePhase {
    public FinalPartialEscapePhase(boolean iterative, CanonicalizerPhase canonicalizer, BasePhase<CoreProviders> cleanupPhase, OptionValues options) {
        super(iterative, PartialEscapePhase.Options.OptEarlyReadElimination.getValue(options), canonicalizer, cleanupPhase, options);
    }

    public FinalPartialEscapePhase(int iterations, CanonicalizerPhase canonicalizer, BasePhase<CoreProviders> cleanupPhase, OptionValues options) {
        super(iterations, PartialEscapePhase.Options.OptEarlyReadElimination.getValue(options), canonicalizer, cleanupPhase);
    }

    @Override
    public Optional<BasePhase.NotApplicable> canApply(GraphState graphState) {
        return BasePhase.NotApplicable.combineConstraints(super.canApply(graphState), BasePhase.NotApplicable.canOnlyApplyOnce(this, GraphState.StageFlag.FINAL_PARTIAL_ESCAPE, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (VirtualUtil.matches(graph, GraalOptions.EscapeAnalyzeOnly.getValue(graph.getOptions()))) {
            graph.getGraphState().setDuringStage(GraphState.StageFlag.FINAL_PARTIAL_ESCAPE);
            super.run(graph, context);
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.FINAL_PARTIAL_ESCAPE);
    }
}

