/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import java.util.Iterator;
import org.graalvm.compiler.core.common.GraalBailoutException;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.truffle.compiler.TruffleTierContext;
import org.graalvm.compiler.truffle.compiler.nodes.asserts.NeverPartOfCompilationNode;

public final class NeverPartOfCompilationPhase
extends BasePhase<TruffleTierContext> {
    @Override
    protected void run(StructuredGraph graph, TruffleTierContext context) {
        graph.checkCancellation();
        Iterator iterator = graph.getNodes(NeverPartOfCompilationNode.TYPE).iterator();
        if (iterator.hasNext()) {
            NeverPartOfCompilationNode neverPartOfCompilationNode = (NeverPartOfCompilationNode)iterator.next();
            NeverPartOfCompilationException neverPartOfCompilationException = new NeverPartOfCompilationException(neverPartOfCompilationNode.getMessage());
            neverPartOfCompilationException.setStackTrace(GraphUtil.approxSourceStackTraceElement(neverPartOfCompilationNode));
            throw neverPartOfCompilationException;
        }
    }

    private static class NeverPartOfCompilationException
    extends GraalBailoutException {
        NeverPartOfCompilationException(String message) {
            super(null, message, new Object[0]);
        }

        @Override
        public boolean isCausedByCompilerAssert() {
            return true;
        }
    }
}

