/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import java.util.function.Predicate;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.truffle.compiler.nodes.SpeculativeExceptionAnchorNode;

public class DeoptimizeOnExceptionPhase
extends Phase {
    private final Predicate<ResolvedJavaMethod> deoptimizeOnExceptionPredicate;

    public DeoptimizeOnExceptionPhase(Predicate<ResolvedJavaMethod> deoptimizeOnExceptionPredicate) {
        this.deoptimizeOnExceptionPredicate = deoptimizeOnExceptionPredicate;
    }

    @Override
    protected void run(StructuredGraph graph) {
        for (Invoke invoke : graph.getInvokes()) {
            InvokeWithExceptionNode invokeWithException;
            ResolvedJavaMethod targetMethod;
            if (!(invoke instanceof InvokeWithExceptionNode) || !this.deoptimizeOnExceptionPredicate.test(targetMethod = (invokeWithException = (InvokeWithExceptionNode)invoke).callTarget().targetMethod())) continue;
            AbstractBeginNode exceptionEdge = invokeWithException.exceptionEdge();
            FixedWithNextNode newNode = graph.add(new SpeculativeExceptionAnchorNode(DeoptimizationReason.TransferToInterpreter, DeoptimizationAction.InvalidateRecompile, targetMethod));
            graph.addAfterFixed(exceptionEdge, newNode);
        }
    }
}

