/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes.arithmetic;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticSplitNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, cyclesRationale="neg+cmp", size=NodeSize.SIZE_2)
public final class IntegerNegExactSplitNode
extends IntegerExactArithmeticSplitNode {
    public static final NodeClass<IntegerNegExactSplitNode> TYPE = NodeClass.create(IntegerNegExactSplitNode.class);
    @Node.Input
    protected ValueNode value;

    public IntegerNegExactSplitNode(Stamp stamp, ValueNode value, AbstractBeginNode next, AbstractBeginNode overflowSuccessor) {
        super(TYPE, stamp, next, overflowSuccessor);
        this.value = value;
    }

    @Override
    protected Value generateArithmetic(NodeLIRBuilderTool gen) {
        return gen.getLIRGeneratorTool().getArithmetic().emitNegate(gen.operand(this.value), true);
    }

    public ValueNode getValue() {
        return this.value;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        NodeView view = NodeView.from(tool);
        if (!IntegerStamp.negateCanOverflow((IntegerStamp)this.value.stamp(view))) {
            tool.deleteBranch(this.overflowSuccessor);
            tool.addToWorkList(this.next);
            NegateNode replacement = this.graph().unique(new NegateNode(this.value));
            this.graph().replaceSplitWithFloating(this, replacement, this.next);
            tool.addToWorkList(replacement);
        }
    }
}

