/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.GenerateStubs;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.ConstantReflectionUtil;
import org.graalvm.compiler.replacements.NodeStrideUtil;
import org.graalvm.compiler.replacements.nodes.ArrayRegionCompareToForeignCalls;
import org.graalvm.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public class ArrayRegionCompareToNode
extends PureFunctionStubIntrinsicNode
implements Canonicalizable,
ConstantReflectionUtil.ArrayBaseOffsetProvider {
    public static final NodeClass<ArrayRegionCompareToNode> TYPE = NodeClass.create(ArrayRegionCompareToNode.class);
    protected final Stride strideA;
    protected final Stride strideB;
    @Node.Input
    protected ValueNode arrayA;
    @Node.Input
    protected ValueNode offsetA;
    @Node.Input
    protected ValueNode arrayB;
    @Node.Input
    protected ValueNode offsetB;
    @Node.Input
    protected ValueNode length;
    @Node.OptionalInput
    protected ValueNode dynamicStrides;

    public ArrayRegionCompareToNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, Stride strideA, Stride strideB, LocationIdentity locationIdentity) {
        this(TYPE, arrayA, offsetA, arrayB, offsetB, length, null, strideA, strideB, null, locationIdentity);
    }

    public ArrayRegionCompareToNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides, LocationIdentity locationIdentity) {
        this(TYPE, arrayA, offsetA, arrayB, offsetB, length, dynamicStrides, null, null, null, locationIdentity);
    }

    public ArrayRegionCompareToNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides) {
        this(TYPE, arrayA, offsetA, arrayB, offsetB, length, dynamicStrides, null, null, null, LocationIdentity.ANY_LOCATION);
    }

    public ArrayRegionCompareToNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(TYPE, arrayA, offsetA, arrayB, offsetB, length, dynamicStrides, null, null, runtimeCheckedCPUFeatures, LocationIdentity.ANY_LOCATION);
    }

    public ArrayRegionCompareToNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, @Node.ConstantNodeParameter Stride strideA, @Node.ConstantNodeParameter Stride strideB) {
        this(TYPE, arrayA, offsetA, arrayB, offsetB, length, null, strideA, strideB, null, LocationIdentity.ANY_LOCATION);
    }

    public ArrayRegionCompareToNode(ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, @Node.ConstantNodeParameter Stride strideA, @Node.ConstantNodeParameter Stride strideB, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(TYPE, arrayA, offsetA, arrayB, offsetB, length, null, strideA, strideB, runtimeCheckedCPUFeatures, LocationIdentity.ANY_LOCATION);
    }

    protected ArrayRegionCompareToNode(NodeClass<? extends ArrayRegionCompareToNode> c, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides, Stride strideA, Stride strideB, EnumSet<?> runtimeCheckedCPUFeatures, LocationIdentity locationIdentity) {
        super(c, StampFactory.forKind(JavaKind.Int), runtimeCheckedCPUFeatures, locationIdentity);
        this.strideA = strideA;
        this.strideB = strideB;
        this.arrayA = arrayA;
        this.offsetA = offsetA;
        this.arrayB = arrayB;
        this.offsetB = offsetB;
        this.length = length;
        this.dynamicStrides = dynamicStrides;
        GraalError.guarantee(strideA == null || strideA.value <= 4, "unsupported strideA");
        GraalError.guarantee(strideB == null || strideB.value <= 4, "unsupported strideB");
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="arrayRegionCompareToS1S1", parameters={"S1", "S1"}), @GenerateStub(name="arrayRegionCompareToS1S2", parameters={"S1", "S2"}), @GenerateStub(name="arrayRegionCompareToS1S4", parameters={"S1", "S4"}), @GenerateStub(name="arrayRegionCompareToS2S1", parameters={"S2", "S1"}), @GenerateStub(name="arrayRegionCompareToS2S2", parameters={"S2", "S2"}), @GenerateStub(name="arrayRegionCompareToS2S4", parameters={"S2", "S4"}), @GenerateStub(name="arrayRegionCompareToS4S1", parameters={"S4", "S1"}), @GenerateStub(name="arrayRegionCompareToS4S2", parameters={"S4", "S2"}), @GenerateStub(name="arrayRegionCompareToS4S4", parameters={"S4", "S4"})})
    public static native int compare(Object var0, long var1, Object var3, long var4, int var6, @Node.ConstantNodeParameter Stride var7, @Node.ConstantNodeParameter Stride var8);

    @Node.NodeIntrinsic
    public static native int compare(Object var0, long var1, Object var3, long var4, int var6, @Node.ConstantNodeParameter Stride var7, @Node.ConstantNodeParameter Stride var8, @Node.ConstantNodeParameter EnumSet<?> var9);

    @Node.NodeIntrinsic
    @GenerateStub(name="arrayRegionCompareToDynamicStrides")
    public static native int compare(Object var0, long var1, Object var3, long var4, int var6, int var7);

    @Node.NodeIntrinsic
    public static native int compare(Object var0, long var1, Object var3, long var4, int var6, int var7, @Node.ConstantNodeParameter EnumSet<?> var8);

    public ValueNode getArrayA() {
        return this.arrayA;
    }

    public ValueNode getOffsetA() {
        return this.offsetA;
    }

    public ValueNode getArrayB() {
        return this.arrayB;
    }

    public ValueNode getOffsetB() {
        return this.offsetB;
    }

    public Stride getStrideA() {
        return this.strideA;
    }

    public Stride getStrideB() {
        return this.strideB;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public int getDirectStubCallIndex() {
        return NodeStrideUtil.getDirectStubCallIndex(this.dynamicStrides, this.strideA, this.strideB);
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return ArrayRegionCompareToForeignCalls.getStub(this);
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        if (this.getDirectStubCallIndex() < 0) {
            return new ValueNode[]{this.arrayA, this.offsetA, this.arrayB, this.offsetB, this.length, this.dynamicStrides};
        }
        return new ValueNode[]{this.arrayA, this.offsetA, this.arrayB, this.offsetB, this.length};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        if (this.getDirectStubCallIndex() < 0) {
            gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitArrayRegionCompareTo(this.getRuntimeCheckedCPUFeatures(), gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.length), gen.operand(this.dynamicStrides)));
        } else {
            gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitArrayRegionCompareTo(NodeStrideUtil.getConstantStrideA(this.dynamicStrides, this.strideA), NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideB), this.getRuntimeCheckedCPUFeatures(), gen.operand(this.arrayA), gen.operand(this.offsetA), gen.operand(this.arrayB), gen.operand(this.offsetB), gen.operand(this.length)));
        }
    }

    @Override
    public int getArrayBaseOffset(MetaAccessProvider metaAccess, ValueNode array, JavaKind arrayKind) {
        return metaAccess.getArrayBaseOffset(arrayKind);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        if ((this.dynamicStrides == null || this.dynamicStrides.isJavaConstant()) && this.length.isJavaConstant()) {
            int len = this.length.asJavaConstant().asInt();
            Stride constStrideA = NodeStrideUtil.getConstantStrideA(this.dynamicStrides, this.strideA);
            Stride constStrideB = NodeStrideUtil.getConstantStrideB(this.dynamicStrides, this.strideB);
            if (len * Math.max(constStrideA.value, constStrideB.value) < GraalOptions.ArrayRegionEqualsConstantLimit.getValue(tool.getOptions()) && ConstantReflectionUtil.canFoldReads(tool, this.arrayA, this.offsetA, constStrideA, len, this) && ConstantReflectionUtil.canFoldReads(tool, this.arrayB, this.offsetB, constStrideB, len, this)) {
                Integer startIndex1 = ConstantReflectionUtil.startIndex(tool, this.arrayA, this.offsetA.asJavaConstant(), constStrideA, this);
                Integer startIndex2 = ConstantReflectionUtil.startIndex(tool, this.arrayB, this.offsetB.asJavaConstant(), constStrideB, this);
                return ConstantNode.forInt(ArrayRegionCompareToNode.foldResult(tool, constStrideA, constStrideB, this.arrayA, startIndex1, this.arrayB, startIndex2, len));
            }
        }
        return this;
    }

    private static int foldResult(CanonicalizerTool tool, Stride constStrideA, Stride constStrideB, ValueNode a, int startIndexA, ValueNode b, int startIndexB, int len) {
        JavaKind arrayKindA = a.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        JavaKind arrayKindB = b.stamp(NodeView.DEFAULT).javaType(tool.getMetaAccess()).getComponentType().getJavaKind();
        ConstantReflectionProvider constantReflection = tool.getConstantReflection();
        for (int i = 0; i < len; ++i) {
            int valueB;
            int valueA = ConstantReflectionUtil.readTypePunned(constantReflection, a.asJavaConstant(), arrayKindA, constStrideA, startIndexA + i);
            int cmp = valueA - (valueB = ConstantReflectionUtil.readTypePunned(constantReflection, b.asJavaConstant(), arrayKindB, constStrideB, startIndexB + i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }
}

