/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements;

import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ClassIsArrayNode;
import org.graalvm.compiler.nodes.extended.ObjectIsArrayNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.InstanceOfSnippetsTemplates;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public abstract class IsArraySnippets
implements Snippets {
    @Snippet
    Object objectIsArraySnippet(@Snippet.NonNullParameter Object object, Object trueValue, Object falseValue) {
        return BranchProbabilityNode.unknownProbability(this.classIsArray(object.getClass())) ? trueValue : falseValue;
    }

    @Snippet
    Object classIsArraySnippet(@Snippet.NonNullParameter Class<?> clazz, Object trueValue, Object falseValue) {
        return BranchProbabilityNode.unknownProbability(this.classIsArray(clazz)) ? trueValue : falseValue;
    }

    protected abstract boolean classIsArray(Class<?> var1);

    public static class Templates
    extends InstanceOfSnippetsTemplates {
        private final SnippetTemplate.SnippetInfo objectIsArraySnippet;
        private final SnippetTemplate.SnippetInfo classIsArraySnippet;

        public Templates(IsArraySnippets receiver, OptionValues options, Providers providers) {
            super(options, providers);
            this.objectIsArraySnippet = this.snippet(IsArraySnippets.class, "objectIsArraySnippet", null, receiver, new LocationIdentity[0]);
            this.classIsArraySnippet = this.snippet(IsArraySnippets.class, "classIsArraySnippet", null, receiver, new LocationIdentity[0]);
        }

        @Override
        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            FloatingNode node = replacer.instanceOf;
            if (node instanceof ObjectIsArrayNode) {
                args = new SnippetTemplate.Arguments(this.objectIsArraySnippet, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("object", ((ObjectIsArrayNode)node).getValue());
            } else if (replacer.instanceOf instanceof ClassIsArrayNode) {
                args = new SnippetTemplate.Arguments(this.classIsArraySnippet, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("clazz", ((ClassIsArrayNode)node).getValue());
            } else {
                throw GraalError.shouldNotReachHere();
            }
            args.add("trueValue", replacer.trueValue);
            args.add("falseValue", replacer.falseValue);
            return args;
        }
    }
}

