/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.printer;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugConfig;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugDumpHandler;
import org.graalvm.compiler.debug.DebugDumpScope;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.contract.NodeCostUtil;
import org.graalvm.compiler.printer.GraphPrinter;
import org.graalvm.compiler.serviceprovider.GraalServices;

public final class GraphPrinterDumpHandler
implements DebugDumpHandler {
    private static final int FAILURE_LIMIT = 8;
    private final GraphPrinterSupplier printerSupplier;
    protected GraphPrinter printer;
    private List<String> previousInlineContext;
    private CompilationIdentifier previousCompilationID = CompilationIdentifier.INVALID_COMPILATION_ID;
    private Graph lastGraph;
    private int lastModCount;
    private int[] dumpIds = new int[0];
    private int failuresCount;
    private Map<Graph, List<String>> inlineContextMap;
    private final String jvmArguments;
    private final String sunJavaCommand;

    public GraphPrinterDumpHandler(GraphPrinterSupplier printerSupplier) {
        this.printerSupplier = printerSupplier;
        this.jvmArguments = GraphPrinterDumpHandler.jvmArguments();
        this.sunJavaCommand = (String)Services.getSavedProperties().get("sun.java.command");
    }

    private static String jvmArguments() {
        List<String> inputArguments = GraalServices.getInputArguments();
        if (inputArguments != null) {
            return String.join((CharSequence)" ", inputArguments);
        }
        return "unknown";
    }

    private void ensureInitialized(DebugContext ctx, Graph graph) {
        if (this.printer == null) {
            if (this.failuresCount >= 8) {
                return;
            }
            this.previousInlineContext = new ArrayList<String>();
            this.inlineContextMap = new WeakHashMap<Graph, List<String>>();
            DebugContext debug = graph.getDebug();
            try {
                this.printer = this.printerSupplier.get(ctx, graph);
            }
            catch (IOException e) {
                this.handleException(debug, e);
            }
        }
    }

    private int nextDumpId() {
        int depth = this.previousInlineContext.size() - 1;
        if (this.dumpIds.length < depth + 1) {
            this.dumpIds = Arrays.copyOf(this.dumpIds, depth + 1);
        }
        int n = depth;
        int n2 = this.dumpIds[n];
        this.dumpIds[n] = n2 + 1;
        return n2;
    }

    @Override
    public void dump(Object object, DebugContext debug, boolean forced, String format, Object ... arguments) {
        OptionValues options = debug.getOptions();
        if (object instanceof Graph && DebugOptions.PrintGraph.getValue(options) != DebugOptions.PrintGraphTarget.Disable) {
            CompilationIdentifier compilationID;
            Graph graph = (Graph)object;
            this.ensureInitialized(debug, graph);
            if (this.printer == null) {
                return;
            }
            List<String> inlineContext = this.getInlineContext(graph);
            if (graph instanceof StructuredGraph && (compilationID = ((StructuredGraph)graph).compilationId()) != CompilationIdentifier.INVALID_COMPILATION_ID) {
                if (this.previousCompilationID != CompilationIdentifier.INVALID_COMPILATION_ID && !compilationID.equals(this.previousCompilationID)) {
                    for (int inlineDepth = this.previousInlineContext.size() - 1; inlineDepth >= 0; --inlineDepth) {
                        this.closeScope(debug, inlineDepth);
                    }
                    this.previousInlineContext = new ArrayList<String>();
                }
                this.previousCompilationID = compilationID;
            }
            if (!inlineContext.equals(this.previousInlineContext)) {
                int inlineDepth;
                int i;
                HashMap<Object, Object> properties = new HashMap<Object, Object>();
                properties.put("graph", graph.toString());
                GraphPrinterDumpHandler.addCompilationId(properties, graph);
                for (i = 0; i < this.previousInlineContext.size(); ++i) {
                    if (i < inlineContext.size() && inlineContext.get(i).equals(this.previousInlineContext.get(i))) continue;
                    for (inlineDepth = this.previousInlineContext.size() - 1; inlineDepth >= i; --inlineDepth) {
                        this.closeScope(debug, inlineDepth);
                    }
                    break;
                }
                for (i = 0; i < inlineContext.size(); ++i) {
                    if (i < this.previousInlineContext.size() && inlineContext.get(i).equals(this.previousInlineContext.get(i))) continue;
                    for (inlineDepth = i; inlineDepth < inlineContext.size(); ++inlineDepth) {
                        this.openScope(debug, inlineContext.get(inlineDepth), inlineDepth, inlineDepth == inlineContext.size() - 1 ? properties : null);
                    }
                    break;
                }
            }
            this.previousInlineContext = inlineContext;
            String currentScopeName = debug.getCurrentScopeName();
            try (DebugContext.Scope s = debug.sandbox("PrintingGraph", null, new Object[0]);){
                HashMap<Object, Object> properties = new HashMap<Object, Object>();
                properties.put("scope", currentScopeName);
                graph.getDebugProperties(properties);
                if (graph instanceof StructuredGraph) {
                    try {
                        int size = NodeCostUtil.computeGraphSize((StructuredGraph)graph);
                        properties.put("node-cost graph size", size);
                    }
                    catch (Throwable t) {
                        properties.put("node-cost-exception", t.getMessage());
                    }
                    properties.put("StageFlags", ((StructuredGraph)graph).getGraphState().getStageFlags());
                }
                if (DebugOptions.PrintUnmodifiedGraphs.getValue(options).booleanValue() || this.lastGraph != graph || this.lastModCount != graph.getEdgeModificationCount()) {
                    this.printer.print(debug, graph, properties, this.nextDumpId(), format, arguments);
                    this.lastGraph = graph;
                    this.lastModCount = graph.getEdgeModificationCount();
                }
            }
            catch (IOException e) {
                this.handleException(debug, e);
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
    }

    void handleException(DebugContext debug, IOException e) {
        if (debug != null && DebugOptions.DumpingErrorsAreFatal.getValue(debug.getOptions()).booleanValue()) {
            throw new GraalError(e);
        }
        this.failuresCount = e instanceof ClosedByInterruptException ? 0 : ++this.failuresCount;
        this.printer = null;
        e.printStackTrace(TTY.out);
        if (this.failuresCount > 8) {
            TTY.println("Too many failures with dumping. Disabling dump in thread " + Thread.currentThread());
        }
    }

    private static void addCompilationId(Map<Object, Object> properties, Graph graph) {
        if (graph instanceof StructuredGraph) {
            properties.put("compilationId", ((StructuredGraph)graph).compilationId());
        }
    }

    private List<String> getInlineContext(Graph graph) {
        List<String> result = this.inlineContextMap.get(graph);
        if (result == null) {
            result = new ArrayList<String>();
            Object lastMethodOrGraph = null;
            boolean graphSeen = false;
            DebugContext debug = graph.getDebug();
            for (Object o : debug.context()) {
                if (o == graph) {
                    graphSeen = true;
                }
                if (o instanceof DebugDumpScope) {
                    DebugDumpScope debugDumpScope = (DebugDumpScope)o;
                    if (debugDumpScope.decorator && !result.isEmpty()) {
                        result.set(result.size() - 1, debugDumpScope.name + ":" + result.get(result.size() - 1));
                    } else {
                        result.add(debugDumpScope.name);
                    }
                } else {
                    GraphPrinterDumpHandler.addMethodContext(result, o, lastMethodOrGraph);
                }
                if (!(o instanceof JavaMethod) && !(o instanceof Graph)) continue;
                lastMethodOrGraph = o;
            }
            for (int i = 0; i < result.size(); ++i) {
                String search;
                String name = result.get(i);
                if (!name.startsWith(search = "TruffleGraal.")) continue;
                result.set(i, "TruffleIR::" + name.substring(search.length(), name.length()));
                if (i <= 0) break;
                result.remove(i - 1);
                break;
            }
            if (result.isEmpty()) {
                result.add(graph.toString());
                graphSeen = true;
            }
            Collections.reverse(result);
            if (!graphSeen) {
                if (DebugConfig.asJavaMethod(graph) != null) {
                    GraphPrinterDumpHandler.addMethodContext(result, graph, lastMethodOrGraph);
                } else {
                    result.add(graph.toString());
                }
            }
            this.inlineContextMap.put(graph, result);
        }
        return result;
    }

    private static void addMethodContext(List<String> result, Object o, Object lastMethodOrGraph) {
        JavaMethod method = DebugConfig.asJavaMethod(o);
        if (method != null && (lastMethodOrGraph == null || DebugConfig.asJavaMethod(lastMethodOrGraph) == null || !DebugConfig.asJavaMethod(lastMethodOrGraph).equals(method) || lastMethodOrGraph != o && lastMethodOrGraph instanceof Graph && o instanceof Graph)) {
            result.add(method.format("%H.%n(%p)"));
        }
    }

    private void openScope(DebugContext debug, String name, int inlineDepth, Map<Object, Object> properties) {
        try {
            Map<Object, Object> props = properties;
            if (inlineDepth == 0) {
                if (props == null) {
                    props = new HashMap<Object, Object>();
                }
                props.put("jvmArguments", this.jvmArguments);
                if (this.sunJavaCommand != null) {
                    props.put("sun.java.command", this.sunJavaCommand);
                }
                props.put("date", new Date().toString());
            }
            this.printer.beginGroup(debug, name, name, debug.contextLookup(ResolvedJavaMethod.class), -1, props);
        }
        catch (IOException e) {
            this.handleException(debug, e);
        }
    }

    private void closeScope(DebugContext debug, int inlineDepth) {
        this.dumpIds[inlineDepth] = 0;
        try {
            if (this.printer != null) {
                this.printer.endGroup();
            }
        }
        catch (IOException e) {
            this.handleException(debug, e);
        }
    }

    @Override
    public void close() {
        if (this.previousInlineContext != null) {
            for (int inlineDepth = 0; inlineDepth < this.previousInlineContext.size(); ++inlineDepth) {
                this.closeScope(null, inlineDepth);
            }
        }
        if (this.printer != null) {
            this.printer.close();
            this.printer = null;
        }
    }

    @FunctionalInterface
    public static interface GraphPrinterSupplier {
        public GraphPrinter get(DebugContext var1, Graph var2) throws IOException;
    }
}

