/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.NodeWithIdentity;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0, allowedUsageTypes={InputType.Condition})
public final class OpaqueLogicNode
extends LogicNode
implements LIRLowerable,
NodeWithIdentity {
    public static final NodeClass<OpaqueLogicNode> TYPE = NodeClass.create(OpaqueLogicNode.class);
    @Node.Input(value=InputType.Condition)
    protected ValueNode value;

    public OpaqueLogicNode(ValueNode value) {
        super((NodeClass<? extends LogicNode>)TYPE);
        this.value = value;
    }

    public ValueNode getValue() {
        return this.value;
    }

    public void setValue(ValueNode value) {
        this.updateUsages(this.value, value);
        this.value = value;
    }

    public void remove() {
        this.replaceAndDelete(this.getValue());
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.setResult(this, gen.operand(this.value));
    }
}

