/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import java.util.Optional;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;

public class LoopSafepointEliminationPhase
extends BasePhase<MidTierContext> {
    private static final long IntegerRangeDistance = Math.abs(0xFFFFFFFFL);

    protected boolean onCallInLoop(LoopEndNode loopEnd, FixedNode currentCallNode) {
        return true;
    }

    protected void onSafepointDisabledLoopBegin(LoopEx loop) {
    }

    protected boolean allowGuestSafepoints() {
        return false;
    }

    public static boolean loopIsIn32BitRange(LoopEx loop) {
        if (loop.counted().getStamp().getBits() <= 32) {
            return true;
        }
        Stamp limitStamp = loop.counted().getTripCountLimit().stamp(NodeView.DEFAULT);
        if (limitStamp instanceof IntegerStamp) {
            IntegerStamp limitIStamp = (IntegerStamp)limitStamp;
            long upperBoundLimit = limitIStamp.upperBound();
            Stamp startStamp = loop.counted().getBodyIVStart().stamp(NodeView.DEFAULT);
            if (startStamp instanceof IntegerStamp) {
                IntegerStamp startIStamp = (IntegerStamp)startStamp;
                long lowerBoundStart = startIStamp.lowerBound();
                if (IntegerStamp.subtractionOverflows(upperBoundLimit, lowerBoundStart, 64)) {
                    return false;
                }
                long startToLimitDistance = Math.abs(upperBoundLimit - lowerBoundStart);
                InductionVariable counter = loop.counted().getLimitCheckedIV();
                long stride = counter.isConstantStride() ? Math.abs(counter.constantStride()) : 1L;
                long strideRelativeStartToLimitDistance = startToLimitDistance / stride;
                return strideRelativeStartToLimitDistance <= IntegerRangeDistance;
            }
        }
        return false;
    }

    @Override
    public Optional<BasePhase.NotApplicable> canApply(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected final void run(StructuredGraph graph, MidTierContext context) {
        LoopsData loops = context.getLoopsDataProvider().getLoopsData(graph);
        loops.detectCountedLoops();
        for (LoopEx loop : loops.countedLoops()) {
            if (!loop.loop().getChildren().isEmpty() || !loop.loopBegin().isPreLoop() && !loop.loopBegin().isPostLoop() && !LoopSafepointEliminationPhase.loopIsIn32BitRange(loop) && !loop.loopBegin().isStripMinedInner()) continue;
            boolean hasSafepoint = false;
            for (LoopEndNode loopEnd : loop.loopBegin().loopEnds()) {
                hasSafepoint |= loopEnd.canSafepoint();
            }
            if (!hasSafepoint) continue;
            if (!loop.counted().counterNeverOverflows()) {
                boolean allowsLoopLimitChecks = context.getOptimisticOptimizations().useLoopLimitChecks(graph.getOptions());
                boolean allowsFloatingGuards = graph.getGuardsStage().allowsFloatingGuards();
                if (!allowsLoopLimitChecks || !allowsFloatingGuards) continue;
                loop.counted().createOverFlowGuard();
            }
            loop.loopBegin().disableSafepoint();
            if (loop.loopBegin().isStripMinedInner()) {
                loop.loopBegin().disableGuestSafepoint();
                continue;
            }
            this.onSafepointDisabledLoopBegin(loop);
        }
        for (LoopEx loop : loops.loops()) {
            if (!this.allowGuestSafepoints()) {
                loop.loopBegin().disableGuestSafepoint();
            }
            block3: for (LoopEndNode loopEnd : loop.loopBegin().loopEnds()) {
                for (Block b = loops.getCFG().blockFor(loopEnd); b != loop.loop().getHeader(); b = (Block)b.getDominator()) {
                    assert (b != null);
                    for (FixedNode node : b.getNodes()) {
                        boolean canDisableSafepoint = LoopSafepointEliminationPhase.canDisableSafepoint(node, context);
                        boolean disabledInSubclass = this.onCallInLoop(loopEnd, node);
                        if (!canDisableSafepoint) continue;
                        loopEnd.disableSafepoint();
                        if (!disabledInSubclass) continue;
                        continue block3;
                    }
                }
            }
        }
        loops.deleteUnusedNodes();
    }

    public static boolean canDisableSafepoint(FixedNode node, CoreProviders context) {
        if (node instanceof Invoke) {
            Invoke invoke = (Invoke)((Object)node);
            ResolvedJavaMethod method = invoke.getTargetMethod();
            return context.getMetaAccessExtensionProvider().isGuaranteedSafepoint(method, invoke.getInvokeKind().isDirect());
        }
        if (node instanceof ForeignCall) {
            return ((ForeignCall)((Object)node)).isGuaranteedSafepoint();
        }
        return false;
    }
}

