/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import java.util.Optional;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.loop.phases.LoopPhase;
import org.graalvm.compiler.loop.phases.LoopTransformations;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopPolicies;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;

public class LoopPeelingPhase
extends LoopPhase<LoopPolicies> {
    public static final CounterKey PEELED = DebugContext.counter("Peeled");

    public LoopPeelingPhase(LoopPolicies policies, CanonicalizerPhase canonicalizer) {
        super(policies, canonicalizer);
    }

    public static boolean canPeel(LoopEx loop) {
        return loop.canDuplicateLoop() && loop.loopBegin().getLoopEndCount() > 0;
    }

    @Override
    public Optional<BasePhase.NotApplicable> canApply(GraphState graphState) {
        return BasePhase.NotApplicable.combineConstraints(super.canApply(graphState), BasePhase.NotApplicable.mustRunBefore(this, GraphState.StageFlag.FSA, graphState), BasePhase.NotApplicable.mustRunBefore(this, GraphState.StageFlag.VALUE_PROXY_REMOVAL, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        DebugContext debug = graph.getDebug();
        if (graph.hasLoops()) {
            LoopsData data = context.getLoopsDataProvider().getLoopsData(graph);
            try (DebugContext.Scope s = debug.scope((Object)"peeling", data.getCFG());){
                for (LoopEx loop : data.outerFirst()) {
                    if (!LoopPeelingPhase.canPeel(loop)) continue;
                    for (int iteration = 0; iteration < Options.IterativePeelingLimit.getValue(graph.getOptions()); ++iteration) {
                        if (!LoopPolicies.Options.PeelALot.getValue(graph.getOptions()).booleanValue() && !this.getPolicies().shouldPeel(loop, data.getCFG(), context, iteration)) continue;
                        debug.log("Peeling %s, iteration %s", (Object)loop, iteration);
                        PEELED.increment(debug);
                        LoopTransformations.peel(loop);
                        loop.invalidateFragmentsAndIVs();
                        data.getCFG().updateCachedLocalLoopFrequency(loop.loopBegin(), f -> f.decrementFrequency(1.0));
                        debug.dump(4, graph, "Peeling %s, iteration %s", loop, iteration);
                    }
                }
                data.deleteUnusedNodes();
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
    }

    @Override
    public float codeSizeIncrease() {
        return 10.0f;
    }

    public static class Options {
        public static final OptionKey<Integer> IterativePeelingLimit = new OptionKey<Integer>(2);
    }
}

