/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.dfa;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collection;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;

class UniqueWorkList
extends ArrayDeque<AbstractBlockBase<?>> {
    private static final long serialVersionUID = 8009554570990975712L;
    BitSet valid;

    UniqueWorkList(int size) {
        this.valid = new BitSet(size);
    }

    @Override
    public AbstractBlockBase<?> poll() {
        AbstractBlockBase result = (AbstractBlockBase)super.poll();
        if (result != null) {
            this.valid.set(result.getId(), false);
        }
        return result;
    }

    @Override
    public boolean add(AbstractBlockBase<?> pred) {
        if (!this.valid.get(pred.getId())) {
            this.valid.set(pred.getId(), true);
            return super.add(pred);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends AbstractBlockBase<?>> collection) {
        boolean changed = false;
        for (AbstractBlockBase<?> element : collection) {
            if (this.valid.get(element.getId())) continue;
            this.valid.set(element.getId(), true);
            super.add(element);
            changed = true;
        }
        return changed;
    }
}

