/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.constopt;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graalvm.compiler.lir.Variable;

class VariableMap<T> {
    private final ArrayList<T> content = new ArrayList();

    VariableMap() {
    }

    public T get(Variable key) {
        if (key == null || key.index >= this.content.size()) {
            return null;
        }
        return this.content.get(key.index);
    }

    public T put(Variable key, T value) {
        assert (key != null) : "Key cannot be null";
        assert (value != null) : "Value cannot be null";
        while (key.index >= this.content.size()) {
            this.content.add(null);
        }
        return this.content.set(key.index, value);
    }

    public T remove(Variable key) {
        assert (key != null) : "Key cannot be null";
        if (key.index >= this.content.size()) {
            return null;
        }
        return this.content.set(key.index, null);
    }

    public void forEach(Consumer<T> action) {
        for (T e : this.content) {
            if (e == null) continue;
            action.accept(e);
        }
    }

    public void filter(Predicate<T> predicate) {
        for (int i = 0; i < this.content.size(); ++i) {
            T e = this.content.get(i);
            if (e == null || predicate.test(e)) continue;
            this.content.set(i, null);
        }
    }
}

