/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64.phases;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.amd64.AMD64Move;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;
import org.graalvm.compiler.options.NestedBooleanOptionKey;

public class StackMoveOptimizationPhase
extends PostAllocationOptimizationPhase {
    private static final CounterKey eliminatedBackup = DebugContext.counter("StackMoveOptimizer[EliminatedScratchBackupRestore]");

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        LIR lir = lirGenRes.getLIR();
        DebugContext debug = lir.getDebug();
        for (AbstractBlockBase block : lir.getControlFlowGraph().getBlocks()) {
            ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(block);
            new Closure().process(debug, instructions);
        }
    }

    private static AMD64Move.AMD64StackMove asStackMove(LIRInstruction inst) {
        assert (StackMoveOptimizationPhase.isStackMove(inst));
        return (AMD64Move.AMD64StackMove)inst;
    }

    private static boolean isStackMove(LIRInstruction inst) {
        return inst instanceof AMD64Move.AMD64StackMove;
    }

    private static class Closure {
        private static final int NONE = -1;
        private int begin = -1;
        private Register reg = null;
        private List<AllocatableValue> dst;
        private List<Value> src;
        private AllocatableValue slot;
        private boolean removed = false;

        private Closure() {
        }

        public void process(DebugContext debug, List<LIRInstruction> instructions) {
            for (int i = 0; i < instructions.size(); ++i) {
                LIRInstruction inst = instructions.get(i);
                if (StackMoveOptimizationPhase.isStackMove(inst)) {
                    AMD64Move.AMD64StackMove move = StackMoveOptimizationPhase.asStackMove(inst);
                    if (this.reg != null && !this.reg.equals((Object)move.getScratchRegister())) {
                        this.replaceStackMoves(debug, instructions);
                    }
                    if (this.dst == null) {
                        assert (this.src == null);
                        this.dst = new ArrayList<AllocatableValue>();
                        this.src = new ArrayList<Value>();
                    }
                    this.dst.add(move.getResult());
                    this.src.add((Value)move.getInput());
                    if (this.begin != -1) continue;
                    this.begin = i;
                    this.reg = move.getScratchRegister();
                    this.slot = move.getBackupSlot();
                    continue;
                }
                if (this.begin == -1) continue;
                this.replaceStackMoves(debug, instructions);
            }
            if (this.removed) {
                instructions.removeAll(Collections.singleton(null));
            }
        }

        private void replaceStackMoves(DebugContext debug, List<LIRInstruction> instructions) {
            int size = this.dst.size();
            if (size > 1) {
                AMD64Move.AMD64MultiStackMove multiMove = new AMD64Move.AMD64MultiStackMove(this.dst.toArray(new AllocatableValue[size]), (Value[])this.src.toArray(new AllocatableValue[size]), this.reg, this.slot);
                instructions.set(this.begin, multiMove);
                Collections.fill(instructions.subList(this.begin + 1, this.begin + size), null);
                this.removed = true;
                eliminatedBackup.add(debug, size - 1);
            }
            this.dst.clear();
            this.src.clear();
            this.begin = -1;
            this.reg = null;
            this.slot = null;
        }
    }

    public static class Options {
        public static final NestedBooleanOptionKey LIROptStackMoveOptimizer = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
    }
}

