/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import java.util.EnumSet;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

public abstract class AMD64ComplexVectorOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64ComplexVectorOp> TYPE = LIRInstructionClass.create(AMD64ComplexVectorOp.class);
    protected final AVXKind.AVXSize vectorSize;
    protected final EnumSet<AMD64.CPUFeature> runtimeCheckedCPUFeatures;
    protected final TargetDescription targetDescription;

    public AMD64ComplexVectorOp(LIRInstructionClass<? extends AMD64ComplexVectorOp> c, LIRGeneratorTool tool, EnumSet<AMD64.CPUFeature> runtimeCheckedCPUFeatures, AVXKind.AVXSize maxUsedVectorSize) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
        this.targetDescription = tool.target();
        this.runtimeCheckedCPUFeatures = runtimeCheckedCPUFeatures;
        AVXKind.AVXSize maxSupportedVectorSize = (AVXKind.AVXSize)tool.getMaxVectorSize(runtimeCheckedCPUFeatures);
        assert (AMD64ComplexVectorOp.isXMMOrGreater(maxUsedVectorSize) && AMD64ComplexVectorOp.isXMMOrGreater(maxSupportedVectorSize));
        this.vectorSize = maxUsedVectorSize.fitsWithin(maxSupportedVectorSize) ? maxUsedVectorSize : maxSupportedVectorSize;
    }

    private static boolean isXMMOrGreater(AVXKind.AVXSize size) {
        return size == AVXKind.AVXSize.XMM || size == AVXKind.AVXSize.YMM || size == AVXKind.AVXSize.ZMM;
    }

    protected AMD64Kind getVectorKind(JavaKind valueKind) {
        switch (this.vectorSize) {
            case XMM: {
                switch (valueKind) {
                    case Byte: {
                        return AMD64Kind.V128_BYTE;
                    }
                    case Char: {
                        return AMD64Kind.V128_WORD;
                    }
                    case Int: {
                        return AMD64Kind.V128_DWORD;
                    }
                    case Long: {
                        return AMD64Kind.V128_QWORD;
                    }
                    case Float: {
                        return AMD64Kind.V128_SINGLE;
                    }
                    case Double: {
                        return AMD64Kind.V128_DOUBLE;
                    }
                }
                throw GraalError.shouldNotReachHere("Unsupported base value kind.");
            }
            case YMM: {
                switch (valueKind) {
                    case Byte: {
                        return AMD64Kind.V256_BYTE;
                    }
                    case Char: {
                        return AMD64Kind.V256_WORD;
                    }
                    case Int: {
                        return AMD64Kind.V256_DWORD;
                    }
                    case Long: {
                        return AMD64Kind.V256_QWORD;
                    }
                    case Float: {
                        return AMD64Kind.V256_SINGLE;
                    }
                    case Double: {
                        return AMD64Kind.V256_DOUBLE;
                    }
                }
                throw GraalError.shouldNotReachHere("Unsupported base value kind.");
            }
            case ZMM: {
                switch (valueKind) {
                    case Byte: {
                        return AMD64Kind.V512_BYTE;
                    }
                    case Char: {
                        return AMD64Kind.V512_WORD;
                    }
                    case Int: {
                        return AMD64Kind.V512_DWORD;
                    }
                    case Long: {
                        return AMD64Kind.V512_QWORD;
                    }
                    case Float: {
                        return AMD64Kind.V512_SINGLE;
                    }
                    case Double: {
                        return AMD64Kind.V512_DOUBLE;
                    }
                }
                throw GraalError.shouldNotReachHere("Unsupported base value kind.");
            }
        }
        throw GraalError.shouldNotReachHere("Unsupported vector size.");
    }

    protected AMD64Kind getVectorKind(Stride stride) {
        switch (this.vectorSize) {
            case XMM: {
                switch (stride) {
                    case S1: {
                        return AMD64Kind.V128_BYTE;
                    }
                    case S2: {
                        return AMD64Kind.V128_WORD;
                    }
                    case S4: {
                        return AMD64Kind.V128_DWORD;
                    }
                    case S8: {
                        return AMD64Kind.V128_QWORD;
                    }
                }
                throw GraalError.shouldNotReachHere("Unsupported base value kind.");
            }
            case YMM: {
                switch (stride) {
                    case S1: {
                        return AMD64Kind.V256_BYTE;
                    }
                    case S2: {
                        return AMD64Kind.V256_WORD;
                    }
                    case S4: {
                        return AMD64Kind.V256_DWORD;
                    }
                    case S8: {
                        return AMD64Kind.V256_QWORD;
                    }
                }
                throw GraalError.shouldNotReachHere("Unsupported base value kind.");
            }
            case ZMM: {
                switch (stride) {
                    case S1: {
                        return AMD64Kind.V512_BYTE;
                    }
                    case S2: {
                        return AMD64Kind.V512_WORD;
                    }
                    case S4: {
                        return AMD64Kind.V512_DWORD;
                    }
                    case S8: {
                        return AMD64Kind.V512_QWORD;
                    }
                }
                throw GraalError.shouldNotReachHere("Unsupported base value kind.");
            }
        }
        throw GraalError.shouldNotReachHere("Unsupported vector size.");
    }

    protected Value[] allocateTempRegisters(LIRGeneratorTool tool, AMD64Kind kind, int n) {
        Value[] temp = new Value[n];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = tool.newVariable(LIRKind.value((PlatformKind)kind));
        }
        return temp;
    }

    protected Value[] allocateVectorRegisters(LIRGeneratorTool tool, JavaKind valueKind, int n) {
        return this.allocateVectorRegisters(tool, LIRKind.value((PlatformKind)this.getVectorKind(valueKind)), n);
    }

    protected Value[] allocateVectorRegisters(LIRGeneratorTool tool, Stride stride, int n) {
        return this.allocateVectorRegisters(tool, LIRKind.value((PlatformKind)this.getVectorKind(stride)), n);
    }

    protected Value[] allocateVectorRegisters(LIRGeneratorTool tool, LIRKind kind, int n) {
        Value[] vectors = new Value[n];
        for (int i = 0; i < vectors.length; ++i) {
            vectors[i] = tool.newVariable(kind);
        }
        return vectors;
    }

    public static boolean supports(TargetDescription target, EnumSet<AMD64.CPUFeature> runtimeCheckedCPUFeatures, AMD64.CPUFeature cpuFeature) {
        return runtimeCheckedCPUFeatures != null && runtimeCheckedCPUFeatures.contains(cpuFeature) || ((AMD64)target.arch).getFeatures().contains(cpuFeature);
    }

    public static boolean supportsAVX512VLBW(TargetDescription target, EnumSet<AMD64.CPUFeature> runtimeCheckedCPUFeatures) {
        return AMD64ComplexVectorOp.supports(target, runtimeCheckedCPUFeatures, AMD64.CPUFeature.AVX512VL) && AMD64ComplexVectorOp.supports(target, runtimeCheckedCPUFeatures, AMD64.CPUFeature.AVX512BW);
    }

    protected boolean supports(AMD64.CPUFeature cpuFeature) {
        return AMD64ComplexVectorOp.supports(this.targetDescription, this.runtimeCheckedCPUFeatures, cpuFeature);
    }

    protected boolean supportsAVX2AndYMM() {
        return AVXKind.AVXSize.YMM.fitsWithin(this.vectorSize) && this.supports(AMD64.CPUFeature.AVX2);
    }

    protected boolean supportsAVX512VLBWAndZMM() {
        return AVXKind.AVXSize.ZMM.fitsWithin(this.vectorSize) && AMD64ComplexVectorOp.supportsAVX512VLBW(this.targetDescription, this.runtimeCheckedCPUFeatures);
    }

    protected boolean supportsBMI2() {
        return this.supports(AMD64.CPUFeature.BMI2);
    }

    protected boolean supportsTZCNT() {
        return this.supports(AMD64.CPUFeature.BMI1) && ((AMD64)this.targetDescription.arch).getFlags().contains(AMD64.Flag.UseCountTrailingZerosInstruction);
    }

    protected void bsfq(AMD64MacroAssembler masm, Register dst, Register src) {
        if (this.supportsTZCNT()) {
            AMD64Assembler.AMD64RMOp.TZCNT.emit((AMD64Assembler)masm, AMD64BaseAssembler.OperandSize.QWORD, dst, src);
        } else {
            masm.bsfq(dst, src);
        }
    }

    @Override
    public boolean needsClearUpperVectorRegisters() {
        return true;
    }
}

