/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.aarch64.AArch64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="AArch64_ENCODE_ARRAY")
@StubPort(path="src/hotspot/cpu/aarch64/macroAssembler_aarch64.cpp", lineStart=5259, lineEnd=5370, commit="77e21c57ce00463db4cc3d87f93729cbfe2c96b4", sha1="1cedae5438e352f0572eb8ffbe1dd379feeb8ba0")
public final class AArch64EncodeArrayOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64EncodeArrayOp> TYPE = LIRInstructionClass.create(AArch64EncodeArrayOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value originSrcValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value originDstValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value lenValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue srcValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue dstValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vectorTempValue0;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vectorTempValue1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vectorTempValue2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vectorTempValue3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vectorTempValue4;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value vectorTempValue5;
    private final LIRGeneratorTool.CharsetName charset;

    public AArch64EncodeArrayOp(LIRGeneratorTool tool, Value result, Value src, Value dst, Value length, LIRGeneratorTool.CharsetName charset) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.resultValue = result;
        this.originSrcValue = src;
        this.originDstValue = dst;
        this.lenValue = length;
        this.srcValue = tool.newVariable(src.getValueKind());
        this.dstValue = tool.newVariable(dst.getValueKind());
        LIRKind vectorKind = LIRKind.value(tool.target().arch.getLargestStorableKind(AArch64.SIMD));
        this.vectorTempValue0 = AArch64.v0.asValue((ValueKind)vectorKind);
        this.vectorTempValue1 = AArch64.v1.asValue((ValueKind)vectorKind);
        this.vectorTempValue2 = AArch64.v2.asValue((ValueKind)vectorKind);
        this.vectorTempValue3 = AArch64.v3.asValue((ValueKind)vectorKind);
        this.vectorTempValue4 = AArch64.v4.asValue((ValueKind)vectorKind);
        this.vectorTempValue5 = AArch64.v5.asValue((ValueKind)vectorKind);
        this.charset = charset;
        assert (charset == LIRGeneratorTool.CharsetName.ASCII || charset == LIRGeneratorTool.CharsetName.ISO_8859_1);
    }

    @Override
    protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        AArch64Move.move(AArch64Kind.QWORD, crb, masm, this.srcValue, this.originSrcValue);
        AArch64Move.move(AArch64Kind.QWORD, crb, masm, this.dstValue, this.originDstValue);
        boolean ascii = this.charset == LIRGeneratorTool.CharsetName.ASCII;
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register len = ValueUtil.asRegister((Value)this.lenValue);
        Register res = ValueUtil.asRegister((Value)this.resultValue);
        Register vtmp0 = ValueUtil.asRegister((Value)this.vectorTempValue0);
        Register vtmp1 = ValueUtil.asRegister((Value)this.vectorTempValue1);
        Register vtmp2 = ValueUtil.asRegister((Value)this.vectorTempValue2);
        Register vtmp3 = ValueUtil.asRegister((Value)this.vectorTempValue3);
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
            Register cnt = res;
            Register max = sc1.getRegister();
            Register chk = sc2.getRegister();
            masm.prfm(AArch64Address.createBaseRegisterOnlyAddress(64, src), AArch64Assembler.PrefetchMode.PLDL1STRM);
            masm.mov(32, cnt, len);
            Label labelLoop32 = new Label();
            Label labelDone32 = new Label();
            Label labelFail32 = new Label();
            masm.bind(labelLoop32);
            masm.compare(32, cnt, 32);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.LT, labelDone32);
            masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.HalfWord, vtmp0, vtmp1, vtmp2, vtmp3, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.HalfWord, src, 64));
            Register vlo0 = ValueUtil.asRegister((Value)this.vectorTempValue4);
            Register vlo1 = ValueUtil.asRegister((Value)this.vectorTempValue5);
            masm.neon.uzp1VVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vlo0, vtmp0, vtmp1);
            masm.neon.uzp1VVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vlo1, vtmp2, vtmp3);
            masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vtmp0, vtmp0, vtmp1);
            masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vtmp2, vtmp2, vtmp3);
            Register vhix = vtmp0;
            masm.neon.uzp2VVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vhix, vtmp0, vtmp2);
            if (ascii) {
                Register vlox = vtmp1;
                masm.neon.orrVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, vlox, vlo0, vlo1);
                masm.neon.umovGX(AArch64ASIMDAssembler.ElementSize.DoubleWord, chk, vhix, 1);
                masm.neon.cmltZeroVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vlox, vlox);
                masm.fmov(64, max, vhix);
                masm.neon.umaxvSV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vlox, vlox);
                masm.orr(64, chk, chk, max);
                masm.neon.umovGX(AArch64ASIMDAssembler.ElementSize.Byte, max, vlo0, 0);
                masm.orr(64, chk, chk, max);
            } else {
                masm.neon.umovGX(AArch64ASIMDAssembler.ElementSize.DoubleWord, chk, vhix, 1);
                masm.fmov(64, max, vhix);
                masm.orr(64, chk, chk, max);
            }
            masm.cbnz(64, chk, labelFail32);
            masm.sub(32, cnt, cnt, 32);
            masm.neon.st1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vlo0, vlo1, AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.ST1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, dst, 32));
            masm.jmp(labelLoop32);
            masm.bind(labelFail32);
            masm.sub(64, src, src, 64);
            masm.bind(labelDone32);
            Label labelLoop8 = new Label();
            Label labelSkip8 = new Label();
            masm.bind(labelLoop8);
            masm.compare(32, cnt, 8);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.LT, labelSkip8);
            Register vhi = vtmp0;
            Register vlo = vtmp1;
            masm.neon.ld1MultipleV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.HalfWord, vtmp3, AArch64Address.createBaseRegisterOnlyAddress(64, src));
            masm.neon.uzp1VVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vlo, vtmp3, vtmp3);
            masm.neon.uzp2VVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vhi, vtmp3, vtmp3);
            if (ascii) {
                masm.neon.cmltZeroVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vtmp2, vlo);
                masm.fmov(64, chk, vhi);
                masm.neon.umaxvSV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, vtmp2, vtmp2);
                masm.neon.umovGX(AArch64ASIMDAssembler.ElementSize.Byte, max, vtmp2, 0);
                masm.orr(64, chk, chk, max);
            } else {
                masm.fmov(64, chk, vhi);
            }
            masm.cbnz(64, chk, labelSkip8);
            masm.fstr(64, vlo, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, dst, 8));
            masm.sub(32, cnt, cnt, 8);
            masm.add(64, src, src, 16);
            masm.jmp(labelLoop8);
            masm.bind(labelSkip8);
            Label labelLoop = new Label();
            Label labelDone = new Label();
            masm.cbz(32, cnt, labelDone);
            masm.bind(labelLoop);
            Register chr = sc1.getRegister();
            masm.ldr(16, chr, AArch64Address.createImmediateAddress(16, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, src, 2));
            masm.tst(32, chr, ascii ? 65408L : 65280L);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, labelDone);
            masm.str(8, chr, AArch64Address.createImmediateAddress(8, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, dst, 1));
            masm.subs(32, cnt, cnt, 1);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.GT, labelLoop);
            masm.bind(labelDone);
            masm.sub(32, res, len, cnt);
        }
    }
}

