/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.ArrayList;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;

public final class ControlFlowOptimizer
extends PostAllocationOptimizationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        LIR lir = lirGenRes.getLIR();
        new Optimizer(lir).deleteEmptyBlocks(lir.getBlocks());
    }

    private static final class Optimizer {
        private final LIR lir;
        private static final CounterKey BLOCKS_DELETED = DebugContext.counter("BlocksDeleted");

        private Optimizer(LIR lir) {
            this.lir = lir;
        }

        private boolean canDeleteBlock(AbstractBlockBase<?> block) {
            if (block == null || block.getSuccessorCount() != 1 || block.getPredecessorCount() == 0 || block.getSuccessors()[0] == block) {
                return false;
            }
            ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
            assert (instructions.size() >= 2) : "block must have label and branch";
            assert (instructions.get(0) instanceof StandardOp.LabelOp) : "first instruction must always be a label";
            assert (instructions.get(instructions.size() - 1) instanceof StandardOp.JumpOp) : "last instruction must always be a branch";
            assert (((StandardOp.JumpOp)instructions.get(instructions.size() - 1)).destination().label() == ((StandardOp.LabelOp)this.lir.getLIRforBlock(block.getSuccessors()[0]).get(0)).getLabel()) : "branch target must be the successor";
            return instructions.size() == 2 && !instructions.get(instructions.size() - 1).hasState() && !block.isExceptionEntry();
        }

        private StandardOp.LabelOp getLabel(AbstractBlockBase<?> block) {
            ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
            assert (instructions.get(0) instanceof StandardOp.LabelOp) : "first instruction must always be a label";
            return (StandardOp.LabelOp)instructions.get(0);
        }

        private void copyAlignment(AbstractBlockBase<?> from, AbstractBlockBase<?> block) {
            if (from.isAligned() && !block.isAligned()) {
                block.setAlign(true);
                this.getLabel(block).setAlignment(this.getLabel(from).getAlignment());
            }
        }

        private void deleteEmptyBlocks(AbstractBlockBase<?>[] blocks) {
            assert (LIR.verifyBlocks(this.lir, blocks));
            for (int i = 0; i < blocks.length; ++i) {
                AbstractBlockBase<?> block = blocks[i];
                if (!this.canDeleteBlock(block)) continue;
                block.delete();
                AbstractBlockBase other = block.getSuccessors()[0];
                this.copyAlignment(block, other);
                BLOCKS_DELETED.increment(this.lir.getDebug());
                blocks[i] = null;
            }
            assert (LIR.verifyBlocks(this.lir, blocks));
        }
    }
}

