/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.EnumSet;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.lir.CompositeValueClass;
import org.graalvm.compiler.lir.InstructionValueConsumer;
import org.graalvm.compiler.lir.InstructionValueProcedure;
import org.graalvm.compiler.lir.LIRInstruction;

public abstract class CompositeValue
extends Value {
    public CompositeValue(ValueKind<?> kind) {
        super(kind);
        assert (CompositeValueClass.get(((Object)((Object)this)).getClass()) != null);
    }

    public abstract CompositeValue forEachComponent(LIRInstruction var1, LIRInstruction.OperandMode var2, InstructionValueProcedure var3);

    protected Value[] visitValueArray(LIRInstruction inst, Value[] values, LIRInstruction.OperandMode mode, InstructionValueProcedure proc, EnumSet<LIRInstruction.OperandFlag> flags) {
        Value[] newValues = null;
        for (int i = 0; i < values.length; ++i) {
            Value value = values[i];
            Value newValue = proc.doValue(inst, value, mode, flags);
            if (value.identityEquals(newValue)) continue;
            if (newValues == null) {
                newValues = (Value[])values.clone();
            }
            newValues[i] = value;
        }
        return newValues != null ? newValues : values;
    }

    protected abstract void visitEachComponent(LIRInstruction var1, LIRInstruction.OperandMode var2, InstructionValueConsumer var3);

    public String toString() {
        return CompositeValueClass.format(this);
    }

    public int hashCode() {
        return 53 * super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompositeValue) {
            CompositeValue other = (CompositeValue)((Object)obj);
            return super.equals((Object)other);
        }
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Component {
        public LIRInstruction.OperandFlag[] value() default {LIRInstruction.OperandFlag.REG};
    }
}

