/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConvertNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.HubGetClassNodeInterface;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.Lowerable;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class HubGetClassNode
extends FloatingNode
implements Lowerable,
Canonicalizable,
ConvertNode,
HubGetClassNodeInterface {
    public static final NodeClass<HubGetClassNode> TYPE = NodeClass.create(HubGetClassNode.class);
    @Node.Input
    protected ValueNode hub;

    public HubGetClassNode(@Node.InjectedNodeParameter MetaAccessProvider metaAccess, ValueNode hub) {
        super((NodeClass<? extends FloatingNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createWithoutAssumptions(metaAccess.lookupJavaType(Class.class))));
        this.hub = hub;
    }

    @Override
    public ValueNode getHub() {
        return this.hub;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ResolvedJavaType exactType;
        if (tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        MetaAccessProvider metaAccess = tool.getMetaAccess();
        if (metaAccess != null && this.hub.isConstant() && (exactType = tool.getConstantReflection().asJavaType(this.hub.asConstant())) != null) {
            return ConstantNode.forConstant(tool.getConstantReflection().asJavaClass(exactType), metaAccess);
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native Class<?> readClass(KlassPointer var0);

    @Override
    public ValueNode getValue() {
        return this.hub;
    }

    @Override
    public Constant convert(Constant c, ConstantReflectionProvider constantReflection) {
        if (JavaConstant.NULL_POINTER.equals(c)) {
            return c;
        }
        return constantReflection.asJavaClass(constantReflection.asJavaType(c));
    }

    @Override
    public Constant reverse(Constant c, ConstantReflectionProvider constantReflection) {
        if (JavaConstant.NULL_POINTER.equals(c)) {
            return c;
        }
        ResolvedJavaType type = constantReflection.asJavaType(c);
        if (type.isPrimitive()) {
            return JavaConstant.NULL_POINTER;
        }
        return constantReflection.asObjectHub(type);
    }

    @Override
    public boolean isLossless() {
        return true;
    }

    @Override
    public boolean mayNullCheckSkipConversion() {
        return true;
    }
}

