/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotLoadReservedReferenceNode;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class HotSpotStoreReservedReferenceNode
extends AbstractStateSplit
implements Lowerable,
SingleMemoryKill {
    public static final NodeClass<HotSpotStoreReservedReferenceNode> TYPE = NodeClass.create(HotSpotStoreReservedReferenceNode.class);
    private final WordTypes wordTypes;
    @Node.Input
    protected ValueNode value;
    private final int jvmciReservedReference0Offset;

    public HotSpotStoreReservedReferenceNode(WordTypes wordTypes, ValueNode value, int jvmciReservedReference0Offset) {
        super((NodeClass<? extends AbstractStateSplit>)TYPE, StampFactory.forVoid());
        this.value = value;
        this.wordTypes = wordTypes;
        this.jvmciReservedReference0Offset = jvmciReservedReference0Offset;
    }

    @Override
    public void lower(LoweringTool tool) {
        CurrentJavaThreadNode thread = this.graph().unique(new CurrentJavaThreadNode(this.wordTypes));
        AddressNode address = this.graph().unique(new OffsetAddressNode(thread, this.graph().unique(ConstantNode.forLong(this.jvmciReservedReference0Offset))));
        JavaWriteNode write = this.graph().add(new JavaWriteNode(JavaKind.Object, address, HotSpotLoadReservedReferenceNode.JVMCI_RESERVED_REFERENCE, this.value, OnHeapMemoryAccess.BarrierType.NONE, false));
        write.setStateAfter(this.stateAfter());
        this.graph().replaceFixedWithFixed(this, write);
        tool.getLowerer().lower(write, tool);
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return HotSpotLoadReservedReferenceNode.JVMCI_RESERVED_REFERENCE;
    }
}

