/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotConstantFieldProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetCounter;

public class HotSpotGraalConstantFieldProvider
extends HotSpotConstantFieldProvider {
    private final MetaAccessProvider metaAccess;
    private ResolvedJavaType cachedHotSpotVMConfigType;
    private ResolvedJavaType cachedSnippetCounterType;
    private ResolvedJavaType cachedNodeClassType;

    public HotSpotGraalConstantFieldProvider(GraalHotSpotVMConfig config, MetaAccessProvider metaAccess) {
        super(config, metaAccess);
        this.metaAccess = metaAccess;
    }

    @Override
    protected boolean isStaticFieldConstant(ResolvedJavaField field, OptionValues options) {
        return super.isStaticFieldConstant(field, options);
    }

    @Override
    protected boolean isFinalFieldValueConstant(ResolvedJavaField field, JavaConstant value, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        if (super.isFinalFieldValueConstant(field, value, tool)) {
            return true;
        }
        if (!field.isStatic()) {
            JavaConstant receiver = tool.getReceiver();
            if (this.getSnippetCounterType().isInstance(receiver) || this.getNodeClassType().isInstance(receiver)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isStableFieldValueConstant(ResolvedJavaField field, JavaConstant value, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        if (super.isStableFieldValueConstant(field, value, tool)) {
            return true;
        }
        if (!field.isStatic()) {
            JavaConstant receiver = tool.getReceiver();
            if (this.getHotSpotVMConfigType().isInstance(receiver)) {
                return true;
            }
        }
        return false;
    }

    private ResolvedJavaType getHotSpotVMConfigType() {
        if (this.cachedHotSpotVMConfigType == null) {
            this.cachedHotSpotVMConfigType = this.metaAccess.lookupJavaType(GraalHotSpotVMConfig.class);
        }
        return this.cachedHotSpotVMConfigType;
    }

    private ResolvedJavaType getSnippetCounterType() {
        if (this.cachedSnippetCounterType == null) {
            this.cachedSnippetCounterType = this.metaAccess.lookupJavaType(SnippetCounter.class);
        }
        return this.cachedSnippetCounterType;
    }

    private ResolvedJavaType getNodeClassType() {
        if (this.cachedNodeClassType == null) {
            this.cachedNodeClassType = this.metaAccess.lookupJavaType(NodeClass.class);
        }
        return this.cachedNodeClassType;
    }
}

