/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterSaveLayout;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotEpilogueOp;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.framemap.FrameMap;

@Opcode(value="LEAVE_CURRENT_STACK_FRAME")
final class AMD64HotSpotLeaveCurrentStackFrameOp
extends AMD64HotSpotEpilogueOp {
    public static final LIRInstructionClass<AMD64HotSpotLeaveCurrentStackFrameOp> TYPE = LIRInstructionClass.create(AMD64HotSpotLeaveCurrentStackFrameOp.class);
    private final StandardOp.SaveRegistersOp saveRegisterOp;

    AMD64HotSpotLeaveCurrentStackFrameOp(StandardOp.SaveRegistersOp saveRegisterOp) {
        super((LIRInstructionClass<? extends AMD64HotSpotEpilogueOp>)TYPE);
        this.saveRegisterOp = saveRegisterOp;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        FrameMap frameMap = crb.frameMap;
        RegisterConfig registerConfig = frameMap.getRegisterConfig();
        RegisterSaveLayout registerSaveLayout = this.saveRegisterOp.getMap(frameMap);
        Register stackPointer = registerConfig.getFrameRegister();
        int stackSlotSize = frameMap.getTarget().wordSize;
        Register integerResultRegister = registerConfig.getReturnRegister(JavaKind.Long);
        masm.movptr(integerResultRegister, new AMD64Address(stackPointer, registerSaveLayout.registerToSlot(integerResultRegister) * stackSlotSize));
        masm.movptr(AMD64.rdx, new AMD64Address(stackPointer, registerSaveLayout.registerToSlot(AMD64.rdx) * stackSlotSize));
        Register floatResultRegister = registerConfig.getReturnRegister(JavaKind.Double);
        masm.movdbl(floatResultRegister, new AMD64Address(stackPointer, registerSaveLayout.registerToSlot(floatResultRegister) * stackSlotSize));
        this.leaveFrameAndRestoreRbp(crb, masm);
        masm.addq(stackPointer, crb.target.arch.getReturnAddressSize());
    }
}

