/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core;

import java.util.List;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.gen.NodeLIRBuilder;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.lir.phases.LIRPhase;
import org.graalvm.compiler.lir.ssa.SSAUtil;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

public class LIRGenerationPhase
extends LIRPhase<LIRGenerationContext> {
    private static final CounterKey instructionCounter = DebugContext.counter("GeneratedLIRInstructions");
    private static final CounterKey nodeCount = DebugContext.counter("FinalNodeCount");

    @Override
    protected final void run(TargetDescription target, LIRGenerationResult lirGenRes, LIRGenerationContext context) {
        AbstractBlockBase[] blocks;
        NodeLIRBuilder nodeLirBuilder = context.nodeLirBuilder;
        StructuredGraph graph = context.graph;
        StructuredGraph.ScheduleResult schedule = context.schedule;
        for (AbstractBlockBase b : blocks = lirGenRes.getLIR().getControlFlowGraph().getBlocks()) {
            LIRGenerationPhase.matchBlock(nodeLirBuilder, (Block)b, schedule);
        }
        for (AbstractBlockBase b : blocks) {
            LIRGenerationPhase.emitBlock(nodeLirBuilder, lirGenRes, (Block)b, graph, schedule.getBlockToNodesMap());
        }
        ((LIRGenerator)context.lirGen).beforeRegisterAllocation();
        assert (SSAUtil.verifySSAForm(lirGenRes.getLIR()));
        nodeCount.add(graph.getDebug(), graph.getNodeCount());
    }

    private static void emitBlock(NodeLIRBuilderTool nodeLirGen, LIRGenerationResult lirGenRes, Block b, StructuredGraph graph, BlockMap<List<Node>> blockMap) {
        assert (!LIRGenerationPhase.isProcessed(lirGenRes, b)) : "Block already processed " + b;
        assert (LIRGenerationPhase.verifyPredecessors(lirGenRes, b));
        nodeLirGen.doBlock(b, graph, blockMap);
        LIR lir = lirGenRes.getLIR();
        DebugContext debug = lir.getDebug();
        instructionCounter.add(debug, lir.getLIRforBlock(b).size());
    }

    private static void matchBlock(NodeLIRBuilder nodeLirGen, Block b, StructuredGraph.ScheduleResult schedule) {
        nodeLirGen.matchBlock(b, schedule);
    }

    private static boolean verifyPredecessors(LIRGenerationResult lirGenRes, Block block) {
        for (Block pred : (Block[])block.getPredecessors()) {
            if (!block.isLoopHeader() || !pred.isLoopEnd()) assert (LIRGenerationPhase.isProcessed(lirGenRes, pred)) : "Predecessor not yet processed " + pred;
        }
        return true;
    }

    private static boolean isProcessed(LIRGenerationResult lirGenRes, Block b) {
        return lirGenRes.getLIR().getLIRforBlock(b) != null;
    }

    public static final class LIRGenerationContext {
        private final NodeLIRBuilder nodeLirBuilder;
        private final LIRGeneratorTool lirGen;
        private final StructuredGraph graph;
        private final StructuredGraph.ScheduleResult schedule;

        public LIRGenerationContext(LIRGeneratorTool lirGen, NodeLIRBuilderTool nodeLirBuilder, StructuredGraph graph, StructuredGraph.ScheduleResult schedule) {
            this.nodeLirBuilder = (NodeLIRBuilder)nodeLirBuilder;
            this.lirGen = lirGen;
            this.graph = graph;
            this.schedule = schedule;
        }
    }
}

