/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import jdk.vm.ci.code.BailoutException;
import org.graalvm.compiler.core.GraalCompilerOptions;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.DiagnosticsOutputDirectory;
import org.graalvm.compiler.debug.PathUtilities;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.options.EnumOptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;

public abstract class CompilationWrapper<T> {
    private final DiagnosticsOutputDirectory outputDirectory;
    private final Map<ExceptionAction, Integer> problemsHandledPerAction;

    public CompilationWrapper(DiagnosticsOutputDirectory outputDirectory, Map<ExceptionAction, Integer> problemsHandledPerAction) {
        this.outputDirectory = outputDirectory;
        this.problemsHandledPerAction = problemsHandledPerAction;
    }

    protected abstract T handleException(Throwable var1);

    protected ExceptionAction lookupAction(OptionValues options, Throwable cause) {
        if (cause instanceof BailoutException && !GraalCompilerOptions.CompilationBailoutAsFailure.getValue(options).booleanValue()) {
            return ExceptionAction.Silent;
        }
        if (GraalCompilerOptions.ExitVMOnException.getValue(options).booleanValue()) {
            assert (GraalCompilerOptions.CompilationFailureAction.getDefaultValue() != ExceptionAction.ExitVM);
            assert (!GraalCompilerOptions.ExitVMOnException.getDefaultValue().booleanValue());
            if (GraalCompilerOptions.CompilationFailureAction.hasBeenSet(options) && GraalCompilerOptions.CompilationFailureAction.getValue(options) != ExceptionAction.ExitVM) {
                TTY.printf("WARNING: Ignoring %s=%s since %s=true has been explicitly specified.%n", GraalCompilerOptions.CompilationFailureAction.getName(), GraalCompilerOptions.CompilationFailureAction.getValue(options), GraalCompilerOptions.ExitVMOnException.getName());
            }
            return ExceptionAction.ExitVM;
        }
        return (ExceptionAction)((Object)GraalCompilerOptions.CompilationFailureAction.getValue(options));
    }

    protected abstract T performCompilation(DebugContext var1);

    public abstract String toString();

    protected abstract DebugContext createRetryDebugContext(DebugContext var1, OptionValues var2, PrintStream var3);

    protected T onCompilationFailure(Failure failure) {
        return failure.handle(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T run(DebugContext initialDebug) {
        try {
            T t = this.performCompilation(initialDebug);
            return t;
        }
        catch (Throwable cause) {
            T t = this.onCompilationFailure(new Failure(cause, initialDebug));
            return t;
        }
        finally {
            GraalServices.notifyLowMemoryPoint(true);
        }
    }

    private static void printCompilationFailureActionAlternatives(PrintStream ps, ExceptionAction ... alternatives) {
        if (alternatives.length > 0) {
            ps.printf("If in an environment where setting system properties is possible, the following%n", new Object[0]);
            ps.printf("properties are available to change compilation failure reporting:%n", new Object[0]);
            for (ExceptionAction action : alternatives) {
                String option = GraalCompilerOptions.CompilationFailureAction.getName();
                if (action == ExceptionAction.Silent) {
                    ps.printf("- To disable compilation failure notifications, set %s to %s (e.g., -Dgraal.%s=%s).%n", new Object[]{option, action, option, action});
                    continue;
                }
                if (action == ExceptionAction.Print) {
                    ps.printf("- To print a message for a compilation failure without retrying the compilation, set %s to %s (e.g., -Dgraal.%s=%s).%n", new Object[]{option, action, option, action});
                    continue;
                }
                if (action != ExceptionAction.Diagnose) continue;
                ps.printf("- To capture more information for diagnosing or reporting a compilation failure, set %s to %s or %s (e.g., -Dgraal.%s=%s).%n", new Object[]{option, action, ExceptionAction.ExitVM, option, action});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T handleFailure(DebugContext initialDebug, Throwable cause) {
        OptionValues initialOptions = initialDebug.getOptions();
        EnumOptionKey<ExceptionAction> enumOptionKey = GraalCompilerOptions.CompilationFailureAction;
        synchronized (enumOptionKey) {
            String message;
            ExceptionAction action = this.lookupAction(initialOptions, cause);
            action = this.adjustAction(initialOptions, action);
            if (action == ExceptionAction.Silent) {
                return this.handleException(cause);
            }
            if (action == ExceptionAction.Print) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (PrintStream ps = new PrintStream(baos);){
                    ps.printf("%s: Compilation of %s failed: ", Thread.currentThread(), this);
                    cause.printStackTrace(ps);
                    CompilationWrapper.printCompilationFailureActionAlternatives(ps, ExceptionAction.Silent, ExceptionAction.Diagnose);
                }
                TTY.print(baos.toString());
                return this.handleException(cause);
            }
            if (DebugOptions.Dump.hasBeenSet(initialOptions)) {
                return this.handleException(cause);
            }
            String dumpPath = null;
            try {
                String dir = this.outputDirectory.getPath();
                if (dir != null) {
                    String dumpName = PathUtilities.sanitizeFileName(this.toString());
                    dumpPath = PathUtilities.createDirectories(PathUtilities.getPath(dir, dumpName));
                }
            }
            catch (Throwable t) {
                TTY.println("Warning: could not create Graal diagnostics directory");
                t.printStackTrace(TTY.out);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintStream ps = new PrintStream(baos);){
                ps.println("[[[Graal compilation failure]]]");
                ps.printf("%s: Compilation of %s failed:%n", Thread.currentThread(), this);
                cause.printStackTrace(ps);
                CompilationWrapper.printCompilationFailureActionAlternatives(ps, ExceptionAction.Silent, ExceptionAction.Print);
                if (dumpPath != null) {
                    ps.println("Retrying compilation of " + this);
                } else {
                    ps.println("Not retrying compilation of " + this + " as the dump path could not be created.");
                }
                message = baos.toString();
            }
            TTY.print(message);
            if (dumpPath == null) {
                return this.handleException(cause);
            }
            String retryLogFile = PathUtilities.getPath(dumpPath, "retry.log");
            try (PrintStream ps = new PrintStream(PathUtilities.openOutputStream(retryLogFile));){
                ps.print(message);
            }
            catch (IOException ioe) {
                TTY.printf("Error writing to %s: %s%n", retryLogFile, ioe);
            }
            OptionValues retryOptions = new OptionValues(initialOptions, DebugOptions.Dump, ":" + DebugOptions.DiagnoseDumpLevel.getValue(initialOptions), DebugOptions.MethodFilter, null, DebugOptions.DumpPath, dumpPath, DebugOptions.PrintBackendCFG, true, GraalOptions.TrackNodeSourcePosition, true);
            ByteArrayOutputStream logBaos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(logBaos);
            try {
                DebugContext retryDebug = this.createRetryDebugContext(initialDebug, retryOptions, ps);
                T res = this.performCompilation(retryDebug);
                ps.println("There was no exception during retry.");
                T t = this.postRetry(action, retryLogFile, logBaos, ps, res);
                return t;
                finally {
                    if (retryDebug != null) {
                        retryDebug.close();
                    }
                }
            }
            catch (Throwable e) {
                ps.println("Exception during retry:");
                e.printStackTrace(ps);
                return this.postRetry(action, retryLogFile, logBaos, ps, this.handleException(cause));
            }
        }
    }

    private T postRetry(ExceptionAction action, String retryLogFile, ByteArrayOutputStream logBaos, PrintStream ps, T res) {
        ps.close();
        try (OutputStream fos = PathUtilities.openOutputStream(retryLogFile, true);){
            fos.write(logBaos.toByteArray());
        }
        catch (Throwable e) {
            TTY.printf("Error writing to %s: %s%n", retryLogFile, e);
        }
        this.maybeExitVM(action);
        return res;
    }

    protected abstract void exitHostVM(int var1);

    private void maybeExitVM(ExceptionAction action) {
        if (action == ExceptionAction.ExitVM) {
            TTY.println("Exiting VM after retry compilation of " + this);
            this.exitHostVM(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExceptionAction adjustAction(OptionValues initialOptions, ExceptionAction initialAction) {
        ExceptionAction action;
        int maxProblems = GraalCompilerOptions.MaxCompilationProblemsPerAction.getValue(initialOptions);
        if (action != ExceptionAction.ExitVM) {
            Map<ExceptionAction, Integer> map = this.problemsHandledPerAction;
            synchronized (map) {
                int problems;
                for (action = initialAction; action != ExceptionAction.Silent && (problems = this.problemsHandledPerAction.getOrDefault((Object)action, 0).intValue()) >= maxProblems; action = action.quieter()) {
                    if (problems != maxProblems) continue;
                    TTY.printf("Warning: adjusting %s from %s to %s after %s (%d) failed compilations%n", new Object[]{GraalCompilerOptions.CompilationFailureAction, action, action.quieter(), GraalCompilerOptions.MaxCompilationProblemsPerAction, maxProblems});
                    this.problemsHandledPerAction.put(action, problems + 1);
                }
                this.problemsHandledPerAction.put(action, this.problemsHandledPerAction.getOrDefault((Object)action, 0) + 1);
            }
        }
        return action;
    }

    public final class Failure {
        public final Throwable cause;
        private final DebugContext debug;

        Failure(Throwable cause, DebugContext debug) {
            this.cause = cause;
            this.debug = debug;
        }

        public T handle(boolean silent) {
            if (silent) {
                return CompilationWrapper.this.handleException(this.cause);
            }
            return CompilationWrapper.this.handleFailure(this.debug, this.cause);
        }
    }

    public static final class ExceptionAction
    extends Enum<ExceptionAction> {
        public static final /* enum */ ExceptionAction Silent = new ExceptionAction();
        public static final /* enum */ ExceptionAction Print = new ExceptionAction();
        public static final /* enum */ ExceptionAction Diagnose = new ExceptionAction();
        public static final /* enum */ ExceptionAction ExitVM = new ExceptionAction();
        private static final ExceptionAction[] VALUES;
        private static final /* synthetic */ ExceptionAction[] $VALUES;

        public static ExceptionAction[] values() {
            return (ExceptionAction[])$VALUES.clone();
        }

        public static ExceptionAction valueOf(String name) {
            return Enum.valueOf(ExceptionAction.class, name);
        }

        ExceptionAction quieter() {
            assert (Silent.ordinal() == 0);
            int index = Math.max(this.ordinal() - 1, 0);
            return VALUES[index];
        }

        static {
            $VALUES = new ExceptionAction[]{Silent, Print, Diagnose, ExitVM};
            VALUES = ExceptionAction.values();
        }
    }
}

