/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;

final class NettyBuffer
implements Buffer {
    private final ByteBuf buffer;

    NettyBuffer(ByteBuf buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer can't be null");
        }
        this.buffer = buffer;
    }

    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    public Buffer readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
        return this;
    }

    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    public Buffer writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
        return this;
    }

    public Buffer markWriterIndex() {
        this.buffer.markWriterIndex();
        return this;
    }

    public Buffer resetWriterIndex() {
        this.buffer.resetWriterIndex();
        return this;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    public byte readByte() {
        return this.buffer.readByte();
    }

    public short readShort() {
        return this.buffer.readShort();
    }

    public int readInt() {
        return this.buffer.readInt();
    }

    public long readLong() {
        return this.buffer.readLong();
    }

    public float readFloat() {
        return this.buffer.readFloat();
    }

    public double readDouble() {
        return this.buffer.readDouble();
    }

    public Buffer readBytes(byte[] destination) {
        this.buffer.readBytes(destination);
        return this;
    }

    public Buffer readBytes(byte[] destination, int dstIndex, int length) {
        this.buffer.readBytes(destination, dstIndex, length);
        return this;
    }

    public Buffer readBytes(ByteBuffer dst) {
        this.buffer.readBytes(dst);
        return this;
    }

    public Buffer readBytes(OutputStream out, int length) throws IOException {
        this.buffer.readBytes(out, length);
        return this;
    }

    public Buffer writeBoolean(boolean value) {
        this.buffer.writeBoolean(value);
        return this;
    }

    public Buffer writeByte(int value) {
        this.buffer.writeByte(value);
        return this;
    }

    public Buffer writeShort(int value) {
        this.buffer.writeShort(value);
        return this;
    }

    public Buffer writeInt(int value) {
        this.buffer.writeInt(value);
        return this;
    }

    public Buffer writeLong(long value) {
        this.buffer.writeLong(value);
        return this;
    }

    public Buffer writeFloat(float value) {
        this.buffer.writeFloat(value);
        return this;
    }

    public Buffer writeDouble(double value) {
        this.buffer.writeDouble(value);
        return this;
    }

    public Buffer writeBytes(byte[] src) {
        this.buffer.writeBytes(src);
        return this;
    }

    public Buffer writeBytes(ByteBuffer src) {
        this.buffer.writeBytes(src);
        return this;
    }

    public Buffer writeBytes(byte[] src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
        return this;
    }

    public boolean release() {
        return this.buffer.release();
    }

    public Buffer retain() {
        this.buffer.retain();
        return this;
    }

    public int referenceCount() {
        return this.buffer.refCnt();
    }

    public ByteBuffer[] nioBuffers() {
        return this.buffer.nioBuffers();
    }

    public ByteBuffer nioBuffer() {
        return this.buffer.nioBuffer();
    }

    public ByteBuffer nioBuffer(int index, int length) {
        return this.buffer.nioBuffer(index, length);
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        return this.buffer.nioBuffers(index, length);
    }

    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    public Buffer getBytes(int index, byte[] dst) {
        this.buffer.getBytes(index, dst);
        return this;
    }

    public ByteBuf getUnderlyingBuffer() {
        return this.buffer;
    }
}

