/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ConnectionPool;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultQueue;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Connection {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private final Channel channel;
    private final URI uri;
    private final ConcurrentMap<UUID, ResultQueue> pending = new ConcurrentHashMap<UUID, ResultQueue>();
    private final Cluster cluster;
    private final Client client;
    private final ConnectionPool pool;
    private final String creatingThread;
    private final String createdTimestamp;
    public static final int MAX_IN_PROCESS = 4;
    public static final int MIN_IN_PROCESS = 1;
    public static final int MAX_WAIT_FOR_CONNECTION = 16000;
    public static final int MAX_WAIT_FOR_CLOSE = 3000;
    public static final int MAX_CONTENT_LENGTH = 65536;
    public static final int RECONNECT_INTERVAL = 1000;
    public static final int RESULT_ITERATION_BATCH_SIZE = 64;
    public static final long KEEP_ALIVE_INTERVAL = 180000L;
    public static final long CONNECTION_SETUP_TIMEOUT_MILLIS = 15000L;
    public final AtomicInteger borrowed = new AtomicInteger(0);
    public final AtomicBoolean isBeingReplaced = new AtomicBoolean(false);
    private final AtomicReference<Class<Channelizer>> channelizerClass = new AtomicReference<Object>(null);
    private final int maxInProcess;
    private final String connectionLabel;
    private final Channelizer channelizer;
    private final AtomicReference<CompletableFuture<Void>> closeFuture = new AtomicReference();
    private final AtomicBoolean shutdownInitiated = new AtomicBoolean(false);

    public Connection(URI uri, ConnectionPool pool, int maxInProcess) throws ConnectionException {
        this.uri = uri;
        this.cluster = pool.getCluster();
        this.client = pool.getClient();
        this.pool = pool;
        this.maxInProcess = maxInProcess;
        this.creatingThread = Thread.currentThread().getName();
        this.createdTimestamp = Instant.now().toString();
        this.connectionLabel = "Connection{host=" + pool.host + "}";
        if (this.cluster.isClosing()) {
            throw new IllegalStateException("Cannot open a connection with the cluster after close() is called");
        }
        Bootstrap b = this.cluster.getFactory().createBootstrap();
        try {
            if (this.channelizerClass.get() == null) {
                this.channelizerClass.compareAndSet(null, Class.forName(this.cluster.connectionPoolSettings().channelizer));
            }
            this.channelizer = this.channelizerClass.get().newInstance();
            this.channelizer.init(this);
            ((Bootstrap)b.channel(NioSocketChannel.class)).handler((ChannelHandler)this.channelizer);
            this.channel = b.connect(uri.getHost(), uri.getPort()).sync().channel();
            this.channelizer.connected();
            Connection thisConnection = this;
            this.channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                logger.debug("OnChannelClose callback called for channel {}", (Object)this.channel);
                if (thisConnection.closeFuture.get() == null) {
                    logger.error(String.format("Server closed the Connection on channel %s - scheduling removal from %s", this.channel.id().asShortText(), thisConnection.pool.getPoolInfo(thisConnection)));
                    thisConnection.cluster.connectionScheduler().submit(() -> thisConnection.pool.definitelyDestroyConnection(thisConnection));
                }
            }));
            logger.info("Created new connection for {}", (Object)uri);
        }
        catch (Exception ex) {
            throw new ConnectionException(uri, "Could not open " + this.getConnectionInfo(true), ex);
        }
    }

    public int availableInProcess() {
        return Math.max(0, this.maxInProcess - this.pending.size());
    }

    public boolean isDead() {
        return this.channel != null && !this.channel.isActive();
    }

    boolean isClosing() {
        return this.closeFuture.get() != null;
    }

    URI getUri() {
        return this.uri;
    }

    Cluster getCluster() {
        return this.cluster;
    }

    Client getClient() {
        return this.client;
    }

    ConcurrentMap<UUID, ResultQueue> getPending() {
        return this.pending;
    }

    public synchronized CompletableFuture<Void> closeAsync() {
        if (this.isClosing()) {
            return this.closeFuture.get();
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.closeFuture.set(future);
        if (this.isOkToClose()) {
            if (null == this.channel) {
                future.complete(null);
            } else {
                this.shutdown(future);
            }
        } else {
            new CheckForPending(future).runUntilDone(this.cluster.connectionScheduler());
        }
        return future;
    }

    public ChannelPromise write(RequestMessage requestMessage, CompletableFuture<ResultSet> resultQueueSetup) {
        if (this.pending.containsKey(requestMessage.getRequestId())) {
            throw new IllegalStateException(String.format("There is already a request pending with an id of: %s", requestMessage.getRequestId()));
        }
        Connection thisConnection = this;
        ChannelPromise requestPromise = this.channel.newPromise().addListener(f -> {
            if (!f.isSuccess()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Write on connection %s failed", thisConnection.getConnectionInfo()), f.cause());
                }
                this.handleConnectionCleanupOnError(thisConnection);
                this.cluster.executor().submit(() -> resultQueueSetup.completeExceptionally(f.cause()));
            } else {
                LinkedBlockingQueue<Result> resultLinkedBlockingQueue = new LinkedBlockingQueue<Result>();
                CompletableFuture<Void> readCompleted = new CompletableFuture<Void>();
                readCompleted.whenCompleteAsync((v, t) -> {
                    if (t != null) {
                        logger.debug("Error while processing request on the server {}.", (Object)this, t);
                        this.handleConnectionCleanupOnError(thisConnection);
                    } else {
                        thisConnection.returnToPool();
                    }
                    this.tryShutdown();
                }, (Executor)this.cluster.executor());
                ResultQueue handler = new ResultQueue(resultLinkedBlockingQueue, readCompleted);
                this.pending.put(requestMessage.getRequestId(), handler);
                this.cluster.executor().submit(() -> resultQueueSetup.complete(new ResultSet(handler, this.cluster.executor(), readCompleted, requestMessage, this.pool.host)));
            }
        });
        this.channel.writeAndFlush((Object)requestMessage, requestPromise);
        return requestPromise;
    }

    private void returnToPool() {
        block3: {
            try {
                if (this.pool != null) {
                    this.pool.returnConnection(this);
                }
            }
            catch (ConnectionException ce) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Returned {} connection to {} but an error occurred - {}", new Object[]{this.getConnectionInfo(), this.pool, ce.getMessage()});
            }
        }
    }

    private void handleConnectionCleanupOnError(Connection thisConnection) {
        if (thisConnection.isDead()) {
            if (this.pool != null) {
                this.pool.replaceConnection(thisConnection);
            }
        } else {
            thisConnection.returnToPool();
        }
    }

    private boolean isOkToClose() {
        return this.pending.isEmpty() || this.channel != null && !this.channel.isOpen() || !this.pool.host.isAvailable();
    }

    private void tryShutdown() {
        if (this.isClosing() && this.isOkToClose()) {
            this.shutdown(this.closeFuture.get());
        }
    }

    private void shutdown(CompletableFuture<Void> future) {
        if (this.shutdownInitiated.compareAndSet(false, true)) {
            if (this.client instanceof Client.SessionedClient) {
                boolean forceClose = this.client.getSettings().getSession().get().isForceClosed();
                RequestMessage closeMessage = this.client.buildMessage(RequestMessage.build("close").addArg("force", forceClose)).create();
                CompletableFuture<ResultSet> closed = new CompletableFuture<ResultSet>();
                this.write(closeMessage, closed);
                try {
                    closed.join().all().get(this.cluster.getMaxWaitForClose(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ex) {
                    String msg = String.format("Timeout while trying to close connection on %s - force closing - server will close session on shutdown or expiration.", ((Client.SessionedClient)this.client).getSessionId());
                    logger.warn(msg, (Throwable)ex);
                }
                catch (Exception ex) {
                    String msg = String.format("Encountered an error trying to close connection on %s - force closing - server will close session on shutdown or expiration.", ((Client.SessionedClient)this.client).getSessionId());
                    logger.warn(msg, (Throwable)ex);
                }
            }
            if (this.channelizer != null) {
                this.channelizer.close(this.channel);
            }
            if (this.channel != null) {
                ChannelPromise promise = this.channel.newPromise();
                promise.addListener(f -> {
                    if (f.cause() != null) {
                        future.completeExceptionally(f.cause());
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{} destroyed successfully.", (Object)this.getConnectionInfo());
                        }
                        future.complete(null);
                    }
                });
                if (!this.channel.closeFuture().isDone()) {
                    this.channel.close(promise);
                } else if (!promise.trySuccess()) {
                    logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)promise);
                }
            } else {
                future.complete(null);
            }
        } else {
            future.complete(null);
        }
    }

    public String getConnectionInfo() {
        return this.getConnectionInfo(true);
    }

    public String getConnectionInfo(boolean showHost) {
        return showHost ? String.format("Connection{channel=%s host=%s isDead=%s borrowed=%s pending=%s markedReplaced=%s closing=%s created=%s thread=%s}", this.getChannelId(), this.pool.host.toString(), this.isDead(), this.borrowed.get(), this.getPending().size(), this.isBeingReplaced, this.isClosing(), this.createdTimestamp, this.creatingThread) : String.format("Connection{channel=%s isDead=%s borrowed=%s pending=%s markedReplaced=%s closing=%s created=%s thread=%s}", this.getChannelId(), this.isDead(), this.borrowed.get(), this.getPending().size(), this.isBeingReplaced, this.isClosing(), this.createdTimestamp, this.creatingThread);
    }

    String getChannelId() {
        return this.channel != null ? this.channel.id().asShortText() : "null";
    }

    public String toString() {
        return String.format(this.connectionLabel + ", {channel=%s}", this.getChannelId());
    }

    private final class CheckForPending
    implements Runnable {
        private volatile ScheduledFuture<?> self;
        private final CompletableFuture<Void> future;
        private long checkUntil = System.currentTimeMillis();

        CheckForPending(CompletableFuture<Void> future) {
            this.future = future;
            this.checkUntil += (long)Connection.this.cluster.getMaxWaitForClose();
        }

        @Override
        public void run() {
            logger.info("Checking for pending messages to complete before close on {}", (Object)this);
            if (Connection.this.isOkToClose() || System.currentTimeMillis() > this.checkUntil) {
                Connection.this.shutdown(this.future);
                boolean interrupted = false;
                try {
                    while (null == this.self) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                    this.self.cancel(false);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        void runUntilDone(ScheduledExecutorService executor) {
            this.self = executor.scheduleAtFixedRate(this, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
    }
}

