/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.vertexcache;

import java.util.Collections;
import java.util.List;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.transaction.vertexcache.VertexCache;
import org.janusgraph.util.datastructures.Retriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyVertexCache
implements VertexCache {
    private static final EmptyVertexCache INSTANCE = new EmptyVertexCache();
    private static final Logger log = LoggerFactory.getLogger(EmptyVertexCache.class);

    private EmptyVertexCache() {
    }

    public static EmptyVertexCache getInstance() {
        return INSTANCE;
    }

    private void logWarning() {
        log.warn("Vertex cache is already closed");
    }

    @Override
    public boolean contains(long id) {
        this.logWarning();
        return false;
    }

    @Override
    public InternalVertex get(long id, Retriever<Long, InternalVertex> retriever) {
        this.logWarning();
        return null;
    }

    @Override
    public void add(InternalVertex vertex, long id) {
        this.logWarning();
    }

    @Override
    public List<InternalVertex> getAllNew() {
        this.logWarning();
        return Collections.emptyList();
    }

    @Override
    public synchronized void close() {
    }
}

