/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.CountGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphMixedIndexCountStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphStep;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphStepStrategy;

public class JanusGraphMixedIndexCountStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final JanusGraphMixedIndexCountStrategy INSTANCE = new JanusGraphMixedIndexCountStrategy();
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> PRIORS = Collections.singleton(JanusGraphStepStrategy.class);

    private JanusGraphMixedIndexCountStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (TraversalHelper.onGraphComputer(traversal)) {
            return;
        }
        TraversalHelper.getStepsOfClass(JanusGraphStep.class, traversal).forEach(originalGraphStep -> this.buildMixedIndexCountStep((JanusGraphStep)originalGraphStep, traversal));
    }

    private void buildMixedIndexCountStep(JanusGraphStep originalGraphStep, Traversal.Admin<?, ?> traversal) {
        if (!originalGraphStep.isStartStep() || !this.hasCountGlobalStep(originalGraphStep)) {
            return;
        }
        JanusGraphMixedIndexCountStep directQueryCountStep = new JanusGraphMixedIndexCountStep(originalGraphStep, traversal);
        if (directQueryCountStep.getMixedIndexCountQuery() != null) {
            this.applyMixedIndexCountStep(originalGraphStep, directQueryCountStep, traversal);
        }
    }

    private boolean isEligibleToSkip(Step currentStep) {
        return currentStep instanceof IdentityStep || currentStep instanceof NoOpBarrierStep;
    }

    private boolean hasCountGlobalStep(GraphStep originalGraphStep) {
        Step currentStep = originalGraphStep.getNextStep();
        while (this.isEligibleToSkip(currentStep)) {
            currentStep = currentStep.getNextStep();
        }
        return currentStep instanceof CountGlobalStep;
    }

    private void applyMixedIndexCountStep(GraphStep originalGraphStep, JanusGraphMixedIndexCountStep mixedIndexCountStep, Traversal.Admin<?, ?> traversal) {
        Step currentStep = originalGraphStep.getNextStep();
        while (this.isEligibleToSkip(currentStep)) {
            currentStep = currentStep.getNextStep();
        }
        assert (currentStep instanceof CountGlobalStep);
        traversal.removeStep(currentStep);
        TraversalHelper.replaceStep((Step)originalGraphStep, (Step)mixedIndexCountStep, traversal);
    }

    public static JanusGraphMixedIndexCountStrategy instance() {
        return INSTANCE;
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return PRIORS;
    }
}

