/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.vertex;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.VertexList;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.database.EdgeSerializer;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.QueryProcessor;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.ResultMergeSortIterator;
import org.janusgraph.graphdb.query.ResultSetIterator;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.DirectionCondition;
import org.janusgraph.graphdb.query.condition.IncidenceCondition;
import org.janusgraph.graphdb.query.condition.Or;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.query.condition.RelationTypeCondition;
import org.janusgraph.graphdb.query.condition.VisibilityFilterCondition;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BaseVertexCentricQuery;
import org.janusgraph.graphdb.query.vertex.BaseVertexCentricQueryBuilder;
import org.janusgraph.graphdb.query.vertex.SimpleVertexQueryProcessor;
import org.janusgraph.graphdb.query.vertex.VertexArrayList;
import org.janusgraph.graphdb.query.vertex.VertexCentricQuery;
import org.janusgraph.graphdb.query.vertex.VertexListInternal;
import org.janusgraph.graphdb.relations.StandardVertexProperty;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.janusgraph.graphdb.types.system.SystemRelationType;
import org.janusgraph.util.datastructures.Interval;
import org.janusgraph.util.datastructures.PointInterval;
import org.janusgraph.util.datastructures.RangeInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicVertexCentricQueryBuilder<Q extends BaseVertexQuery<Q>>
extends BaseVertexCentricQueryBuilder<Q> {
    private static final Logger log = LoggerFactory.getLogger(BasicVertexCentricQueryBuilder.class);
    protected final StandardJanusGraphTx tx;
    protected QueryProfiler profiler = QueryProfiler.NO_OP;
    private boolean querySystem = false;
    private boolean queryOnlyLoaded = false;
    private boolean queryOnlyGivenVertex = false;
    private boolean restrict2Partitions = true;
    private static final int HARD_MAX_LIMIT = 300000;

    public BasicVertexCentricQueryBuilder(StandardJanusGraphTx tx) {
        super(tx);
        this.tx = (StandardJanusGraphTx)Preconditions.checkNotNull((Object)tx);
    }

    @Override
    public JanusGraphVertex getVertex(long vertexId) {
        return this.tx.getVertex(vertexId);
    }

    public Q noPartitionRestriction() {
        this.restrict2Partitions = false;
        return this.getThis();
    }

    public Q profiler(QueryProfiler profiler) {
        Preconditions.checkNotNull((Object)profiler);
        this.profiler = profiler;
        return this.getThis();
    }

    public Q system() {
        this.querySystem = true;
        return this.getThis();
    }

    public Q queryOnlyLoaded() {
        this.queryOnlyLoaded = true;
        return this.getThis();
    }

    public Q queryOnlyGivenVertex() {
        this.queryOnlyGivenVertex = true;
        return this.getThis();
    }

    protected boolean hasAllCanonicalTypes() {
        if (this.types.length == 0) {
            return false;
        }
        for (String typeName : this.types) {
            InternalRelationType type = QueryUtil.getType(this.tx, typeName);
            if (type == null || type.isPropertyKey() || type.multiplicity().isUnique(this.dir)) continue;
            return false;
        }
        return true;
    }

    public boolean hasQueryOnlyGivenVertex() {
        return this.queryOnlyGivenVertex;
    }

    public boolean hasQueryOnlyLoaded() {
        return this.queryOnlyLoaded;
    }

    protected static Iterable<JanusGraphVertex> edges2Vertices(Iterable<JanusGraphEdge> edges, final JanusGraphVertex other) {
        return Iterables.transform(edges, (Function)new Function<JanusGraphEdge, JanusGraphVertex>(){

            @Nullable
            public JanusGraphVertex apply(@Nullable JanusGraphEdge janusgraphEdge) {
                return janusgraphEdge.otherVertex(other);
            }
        });
    }

    protected VertexList edges2VertexIds(Iterable<JanusGraphEdge> edges, JanusGraphVertex other) {
        VertexArrayList vertices = new VertexArrayList(this.tx);
        for (JanusGraphEdge edge : edges) {
            vertices.add(edge.otherVertex(other));
        }
        return vertices;
    }

    protected Iterable<JanusGraphRelation> executeImplicitKeyQuery(InternalVertex v) {
        assert (this.isImplicitKeyQuery(RelationCategory.PROPERTY));
        if (this.dir == Direction.IN || this.limit < 1) {
            return ImmutableList.of();
        }
        ImplicitKey key = (ImplicitKey)this.tx.getRelationType(this.types[0]);
        return ImmutableList.of((Object)new StandardVertexProperty(0L, key, v, key.computeProperty(v), v.isNew() ? (byte)1 : 2));
    }

    protected List<InternalVertex> allRequiredRepresentatives(InternalVertex partitionedVertex) {
        if (this.hasAllCanonicalTypes()) {
            return ImmutableList.of((Object)this.tx.getCanonicalVertex(partitionedVertex));
        }
        return Arrays.asList(this.tx.getAllRepresentatives(partitionedVertex, this.restrict2Partitions));
    }

    protected final boolean isPartitionedVertex(InternalVertex vertex) {
        return this.tx.isPartitionedVertex(vertex) && !this.queryOnlyGivenVertex;
    }

    protected boolean useSimpleQueryProcessor(BaseVertexCentricQuery query, InternalVertex ... vertices) {
        assert (vertices.length > 0);
        if (!query.isSimple()) {
            return false;
        }
        if (this.queryOnlyLoaded) {
            return true;
        }
        for (InternalVertex vertex : vertices) {
            if (vertex.isLoaded()) continue;
            return false;
        }
        return true;
    }

    protected Iterable<JanusGraphRelation> executeRelations(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        if (this.isPartitionedVertex(vertex)) {
            if (!this.hasAllCanonicalTypes()) {
                InternalVertex[] representatives = this.tx.getAllRepresentatives(vertex, this.restrict2Partitions);
                Iterable<JanusGraphElement> merge = null;
                for (InternalVertex rep : representatives) {
                    Iterable<JanusGraphRelation> iterable = this.executeIndividualRelations(rep, baseQuery);
                    merge = merge == null ? iterable : ResultMergeSortIterator.mergeSort(merge, iterable, this.orders, false);
                }
                return ResultSetIterator.wrap(merge, baseQuery.getLimit());
            }
            vertex = this.tx.getCanonicalVertex(vertex);
        }
        return this.executeIndividualRelations(vertex, baseQuery);
    }

    private Iterable<JanusGraphRelation> executeIndividualRelations(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        VertexCentricQuery query = this.constructQuery(vertex, baseQuery);
        return this.executeIndividualRelations(vertex, query);
    }

    private Iterable<JanusGraphRelation> executeIndividualRelations(InternalVertex vertex, VertexCentricQuery query) {
        if (this.useSimpleQueryProcessor(query, vertex)) {
            return new SimpleVertexQueryProcessor(query, this.tx).relations();
        }
        return new QueryProcessor<VertexCentricQuery, JanusGraphRelation, SliceQuery>(query, this.tx.edgeProcessor);
    }

    public Iterable<JanusGraphVertex> executeVertices(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        if (this.isPartitionedVertex(vertex)) {
            if (!this.orders.isEmpty()) {
                return this.edges2VertexIds(this.executeRelations(vertex, baseQuery), vertex);
            }
            if (!this.hasAllCanonicalTypes()) {
                InternalVertex[] representatives = this.tx.getAllRepresentatives(vertex, this.restrict2Partitions);
                Iterable<JanusGraphVertex> merge = null;
                for (InternalVertex rep : representatives) {
                    Iterable<JanusGraphVertex> iterable = this.executeIndividualVertices(rep, baseQuery);
                    merge = merge == null ? iterable : ResultMergeSortIterator.mergeSort(merge, iterable, VertexArrayList.VERTEX_ID_COMPARATOR, false);
                }
                return ResultSetIterator.wrap(merge, baseQuery.getLimit());
            }
            vertex = this.tx.getCanonicalVertex(vertex);
        }
        return this.executeIndividualVertices(vertex, baseQuery);
    }

    private Iterable<JanusGraphVertex> executeIndividualVertices(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        VertexCentricQuery query = this.constructQuery(vertex, baseQuery);
        if (this.useSimpleQueryProcessor(query, vertex)) {
            return new SimpleVertexQueryProcessor(query, this.tx).vertexIds();
        }
        return BasicVertexCentricQueryBuilder.edges2Vertices(this.executeIndividualRelations(vertex, query), query.getVertex());
    }

    public VertexList executeVertexIds(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        if (this.isPartitionedVertex(vertex)) {
            if (!this.orders.isEmpty()) {
                return this.edges2VertexIds(this.executeRelations(vertex, baseQuery), vertex);
            }
            if (!this.hasAllCanonicalTypes()) {
                InternalVertex[] representatives = this.tx.getAllRepresentatives(vertex, this.restrict2Partitions);
                VertexList merge = null;
                for (InternalVertex rep : representatives) {
                    if (merge != null && merge.size() >= baseQuery.getLimit()) break;
                    VertexList vertexList = this.executeIndividualVertexIds(rep, baseQuery);
                    if (merge == null) {
                        merge = (VertexListInternal)vertexList;
                        continue;
                    }
                    merge.addAll(vertexList);
                }
                if (merge != null && merge.size() > baseQuery.getLimit()) {
                    merge = (VertexListInternal)merge.subList(0, baseQuery.getLimit());
                }
                return merge;
            }
            vertex = this.tx.getCanonicalVertex(vertex);
        }
        return this.executeIndividualVertexIds(vertex, baseQuery);
    }

    private VertexList executeIndividualVertexIds(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        VertexCentricQuery query = this.constructQuery(vertex, baseQuery);
        if (this.useSimpleQueryProcessor(query, vertex)) {
            return new SimpleVertexQueryProcessor(query, this.tx).vertexIds();
        }
        return this.edges2VertexIds(this.executeIndividualRelations(vertex, query), vertex);
    }

    protected VertexCentricQuery constructQuery(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        Condition<JanusGraphRelation> condition = baseQuery.getCondition();
        if (!baseQuery.isEmpty()) {
            And<JanusGraphRelation> newCondition = new And<JanusGraphRelation>();
            if (condition instanceof And) {
                newCondition.addAll((And)condition);
            } else {
                newCondition.add(condition);
            }
            newCondition.add(new DirectionCondition(vertex, this.dir));
            if (this.adjacentVertex != null) {
                newCondition.add(new IncidenceCondition(vertex, this.adjacentVertex));
            }
            condition = newCondition;
        }
        VertexCentricQuery query = new VertexCentricQuery(vertex, condition, baseQuery.getDirection(), baseQuery.getQueries(), baseQuery.getOrders(), baseQuery.getLimit());
        Preconditions.checkArgument((!this.queryOnlyLoaded || query.isSimple() ? 1 : 0) != 0, (Object)"Query-only-loaded only works on simple queries");
        return query;
    }

    protected BaseVertexCentricQuery constructQuery(RelationCategory returnType) {
        QueryProfiler optProfiler = this.profiler.addNested("optimization");
        optProfiler.startTimer();
        BaseVertexCentricQuery query = this.constructQueryWithoutProfile(returnType);
        optProfiler.stopTimer();
        query.observeWith(this.profiler);
        return query;
    }

    protected BaseVertexCentricQuery constructQueryWithoutProfile(RelationCategory returnType) {
        ImmutableList queries;
        assert (returnType != null);
        Preconditions.checkArgument((this.adjacentVertex == null || returnType == RelationCategory.EDGE ? 1 : 0) != 0, (Object)"Vertex constraints only apply to edges");
        if (this.limit <= 0) {
            return BaseVertexCentricQuery.emptyQuery();
        }
        if (returnType == RelationCategory.PROPERTY) {
            if (this.dir == Direction.IN) {
                return BaseVertexCentricQuery.emptyQuery();
            }
            this.dir = Direction.OUT;
        }
        this.orders.makeImmutable();
        assert (this.orders.hasCommonOrder());
        And<JanusGraphRelation> conditions = QueryUtil.constraints2QNF(this.tx, this.constraints);
        if (conditions == null) {
            return BaseVertexCentricQuery.emptyQuery();
        }
        int sliceLimit = this.limit;
        EdgeSerializer serializer = this.tx.getEdgeSerializer();
        if (!this.hasTypes()) {
            BackendQueryHolder<SliceQuery> query = new BackendQueryHolder<SliceQuery>(serializer.getQuery(returnType, this.querySystem), (this.adjacentVertex == null && this.dir == Direction.BOTH || returnType == RelationCategory.PROPERTY && this.dir == Direction.OUT) && !conditions.hasChildren(), this.orders.isEmpty());
            if (sliceLimit != Integer.MAX_VALUE && sliceLimit < 0x2AAAAAAA && this.dir != Direction.BOTH && (returnType == RelationCategory.EDGE || returnType == RelationCategory.RELATION)) {
                sliceLimit *= 2;
            }
            query.getBackendQuery().setLimit(this.computeLimit(conditions.size(), sliceLimit));
            queries = ImmutableList.of(query);
            conditions.add(returnType);
            conditions.add(new VisibilityFilterCondition(this.querySystem ? VisibilityFilterCondition.Visibility.SYSTEM : VisibilityFilterCondition.Visibility.NORMAL));
        } else {
            HashSet<RelationType> ts = new HashSet<RelationType>(this.types.length);
            queries = new ArrayList(this.types.length + 2);
            HashMap<RelationType, Interval> intervalConstraints = new HashMap<RelationType, Interval>(conditions.size());
            boolean isIntervalFittedConditions = this.compileConstraints(conditions, intervalConstraints);
            for (Interval pint : intervalConstraints.values()) {
                if (!pint.isEmpty()) continue;
                return BaseVertexCentricQuery.emptyQuery();
            }
            for (String typeName : this.types) {
                InternalRelationType type;
                if (typeName == null || (type = QueryUtil.getType(this.tx, typeName)) == null) continue;
                Preconditions.checkArgument((!this.querySystem || type instanceof SystemRelationType ? 1 : 0) != 0, (String)"Can only query for system types: %s", (Object)type);
                if (type instanceof ImplicitKey) {
                    throw new UnsupportedOperationException("Implicit types are not supported in complex queries: " + type);
                }
                ts.add(type);
                Direction typeDir = this.dir;
                if (type.isPropertyKey()) {
                    Preconditions.checkArgument((returnType != RelationCategory.EDGE ? 1 : 0) != 0, (String)"Querying for edges but including a property key: %s", (Object)type.name());
                    returnType = RelationCategory.PROPERTY;
                    typeDir = Direction.OUT;
                }
                if (type.isEdgeLabel()) {
                    Preconditions.checkArgument((returnType != RelationCategory.PROPERTY ? 1 : 0) != 0, (String)"Querying for properties but including an edge label: %s", (Object)type.name());
                    returnType = RelationCategory.EDGE;
                    if (!type.isUnidirected(Direction.BOTH)) {
                        if (typeDir == Direction.BOTH) {
                            typeDir = type.isUnidirected(Direction.OUT) ? Direction.OUT : Direction.IN;
                        } else if (!type.isUnidirected(typeDir)) continue;
                    }
                }
                if (type.isEdgeLabel() && typeDir == Direction.BOTH && intervalConstraints.isEmpty() && this.orders.isEmpty()) {
                    SliceQuery q = serializer.getQuery(type, typeDir, null);
                    q.setLimit(sliceLimit);
                    queries.add(new BackendQueryHolder<SliceQuery>(q, isIntervalFittedConditions, true));
                    continue;
                }
                Direction[] dirs = new Direction[]{typeDir};
                if (typeDir == Direction.BOTH) {
                    dirs = type.isEdgeLabel() ? new Direction[]{Direction.OUT, Direction.IN} : new Direction[]{Direction.OUT};
                }
                for (Direction direction : dirs) {
                    InternalRelationType bestCandidate = null;
                    double bestScore = Double.NEGATIVE_INFINITY;
                    boolean bestCandidateSupportsOrder = false;
                    PropertyKey[] bestCandidateExtendedSortKey = null;
                    for (InternalRelationType candidate : type.getRelationIndexes()) {
                        PropertyKey[] extendedSortKey;
                        if (!candidate.isUnidirected(Direction.BOTH) && !candidate.isUnidirected(direction) || !candidate.equals(type) && candidate.getStatus() != SchemaStatus.ENABLED) continue;
                        boolean supportsOrder = this.orders.isEmpty() || this.orders.getCommonOrder() == candidate.getSortOrder();
                        int currentOrder = 0;
                        double score = 0.0;
                        for (PropertyKey keyType : extendedSortKey = BasicVertexCentricQueryBuilder.getExtendedSortKey(candidate, direction, this.tx)) {
                            Interval interval;
                            if (currentOrder < this.orders.size() && this.orders.getKey(currentOrder).equals(keyType)) {
                                ++currentOrder;
                            }
                            if ((interval = (Interval)intervalConstraints.get(keyType)) == null || !interval.isPoints()) {
                                if (interval == null) break;
                                score += 1.0;
                                break;
                            }
                            assert (interval.isPoints());
                            score += 5.0 / (double)interval.getPoints().size();
                        }
                        if (supportsOrder && currentOrder == this.orders.size()) {
                            score += 3.0;
                        }
                        if (!(score > bestScore)) continue;
                        bestScore = score;
                        bestCandidate = candidate;
                        bestCandidateSupportsOrder = supportsOrder && currentOrder == this.orders.size();
                        bestCandidateExtendedSortKey = extendedSortKey;
                    }
                    Preconditions.checkArgument((bestCandidate != null ? 1 : 0) != 0, (String)"Current graph schema does not support the specified query constraints for type: %s", (Object)type.name());
                    EdgeSerializer.TypedInterval[] sortKeyConstraints = new EdgeSerializer.TypedInterval[bestCandidateExtendedSortKey.length];
                    this.constructSliceQueries(bestCandidateExtendedSortKey, sortKeyConstraints, 0, bestCandidate, direction, intervalConstraints, sliceLimit, isIntervalFittedConditions, bestCandidateSupportsOrder, (List<BackendQueryHolder<SliceQuery>>)queries);
                }
            }
            if (queries.isEmpty()) {
                return BaseVertexCentricQuery.emptyQuery();
            }
            conditions.add(BasicVertexCentricQueryBuilder.getTypeCondition(ts));
        }
        return new BaseVertexCentricQuery(QueryUtil.simplifyAnd(conditions), this.dir, (List<BackendQueryHolder<SliceQuery>>)queries, this.orders, this.limit);
    }

    private void constructSliceQueries(PropertyKey[] extendedSortKey, EdgeSerializer.TypedInterval[] sortKeyConstraints, int position, InternalRelationType bestCandidate, Direction direction, Map<RelationType, Interval> intervalConstraints, int sliceLimit, boolean isIntervalFittedConditions, boolean bestCandidateSupportsOrder, List<BackendQueryHolder<SliceQuery>> queries) {
        boolean isFitted;
        if (position < extendedSortKey.length) {
            PropertyKey keyType = extendedSortKey[position];
            Interval interval = intervalConstraints.get(keyType);
            if (interval != null) {
                sortKeyConstraints[position] = new EdgeSerializer.TypedInterval(keyType, interval);
                ++position;
            }
            if (interval != null && interval.isPoints()) {
                for (Object point : interval.getPoints()) {
                    EdgeSerializer.TypedInterval[] clonedSKC = Arrays.copyOf(sortKeyConstraints, sortKeyConstraints.length);
                    clonedSKC[position - 1] = new EdgeSerializer.TypedInterval(keyType, new PointInterval(point));
                    this.constructSliceQueries(extendedSortKey, clonedSKC, position, bestCandidate, direction, intervalConstraints, sliceLimit, isIntervalFittedConditions, bestCandidateSupportsOrder, queries);
                }
                return;
            }
        }
        boolean bl = isFitted = isIntervalFittedConditions && position == intervalConstraints.size();
        if (isFitted && position > 0) {
            EdgeSerializer.TypedInterval lastInterval = sortKeyConstraints[position - 1];
            if (!lastInterval.interval.isPoints() && lastInterval.interval.getEnd() == null) {
                isFitted = false;
            }
        }
        EdgeSerializer serializer = this.tx.getEdgeSerializer();
        SliceQuery q = serializer.getQuery(bestCandidate, direction, sortKeyConstraints);
        q.setLimit(this.computeLimit(intervalConstraints.size() - position, sliceLimit));
        queries.add(new BackendQueryHolder<SliceQuery>(q, isFitted, bestCandidateSupportsOrder));
    }

    private static PropertyKey[] getExtendedSortKey(InternalRelationType type, Direction dir, StandardJanusGraphTx tx) {
        int additional = 0;
        if (!type.multiplicity().isUnique(dir)) {
            if (!type.multiplicity().isConstrained()) {
                ++additional;
            }
            if (type.isEdgeLabel()) {
                ++additional;
            }
        }
        PropertyKey[] entireKey = new PropertyKey[type.getSortKey().length + additional];
        for (int i = 0; i < type.getSortKey().length; ++i) {
            entireKey[i] = tx.getExistingPropertyKey(type.getSortKey()[i]);
        }
        if (type.isEdgeLabel() && !type.multiplicity().isUnique(dir)) {
            entireKey[i++] = ImplicitKey.ADJACENT_ID;
        }
        if (!type.multiplicity().isConstrained()) {
            entireKey[i] = ImplicitKey.JANUSGRAPHID;
        }
        return entireKey;
    }

    private boolean compileConstraints(And<JanusGraphRelation> conditions, Map<RelationType, Interval> constraintMap) {
        boolean isFitted = true;
        for (Condition condition : conditions.getChildren()) {
            RelationType type = null;
            Interval newInterval = null;
            if (condition instanceof Or) {
                Map.Entry<RelationType, Collection> orEqual = QueryUtil.extractOrCondition((Or)condition);
                if (orEqual != null) {
                    type = orEqual.getKey();
                    newInterval = new PointInterval(orEqual.getValue());
                }
            } else if (condition instanceof PredicateCondition) {
                PredicateCondition atom = (PredicateCondition)condition;
                type = (RelationType)atom.getKey();
                Interval interval = constraintMap.get(type);
                newInterval = BasicVertexCentricQueryBuilder.intersectConstraints(interval, type, atom.getPredicate(), atom.getValue());
            }
            if (newInterval != null) {
                constraintMap.put(type, newInterval);
                continue;
            }
            isFitted = false;
        }
        if (this.adjacentVertex != null) {
            if (this.adjacentVertex.hasId()) {
                constraintMap.put(ImplicitKey.ADJACENT_ID, new PointInterval<Long>(this.adjacentVertex.longId()));
            } else {
                isFitted = false;
            }
        }
        return isFitted;
    }

    private static Interval intersectConstraints(Interval pint, RelationType type, JanusGraphPredicate predicate, Object value) {
        Interval<Object> newInt;
        block11: {
            block10: {
                if (!(predicate instanceof Cmp)) break block10;
                switch ((Cmp)predicate) {
                    case EQUAL: {
                        if (value == null) {
                            return null;
                        }
                        newInt = new PointInterval<Object>(value);
                        break block11;
                    }
                    case NOT_EQUAL: {
                        return null;
                    }
                    case LESS_THAN: {
                        newInt = new RangeInterval<Object>().setEnd(value, false);
                        break block11;
                    }
                    case LESS_THAN_EQUAL: {
                        newInt = new RangeInterval<Object>().setEnd(value, true);
                        break block11;
                    }
                    case GREATER_THAN: {
                        newInt = new RangeInterval<Object>().setStart(value, false);
                        break block11;
                    }
                    case GREATER_THAN_EQUAL: {
                        newInt = new RangeInterval<Object>().setStart(value, true);
                        break block11;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            return null;
        }
        assert (newInt != null);
        return pint != null ? pint.intersect(newInt) : newInt;
    }

    private static Condition<JanusGraphRelation> getTypeCondition(Set<RelationType> types) {
        assert (!types.isEmpty());
        if (types.size() == 1) {
            return new RelationTypeCondition<JanusGraphRelation>(types.iterator().next());
        }
        Or<JanusGraphRelation> typeCond = new Or<JanusGraphRelation>(types.size());
        for (RelationType type : types) {
            typeCond.add(new RelationTypeCondition(type));
        }
        return typeCond;
    }

    private int computeLimit(int remainingConditions, int baseLimit) {
        if (baseLimit == Integer.MAX_VALUE) {
            return baseLimit;
        }
        assert (baseLimit > 0);
        baseLimit = Math.max(baseLimit, Math.min(300000, QueryUtil.adjustLimitForTxModifications(this.tx, remainingConditions, baseLimit)));
        assert (baseLimit > 0);
        return baseLimit;
    }

    protected class VertexIdConstructor
    implements ResultConstructor<VertexList> {
        protected VertexIdConstructor() {
        }

        @Override
        public VertexList getResult(InternalVertex v, BaseVertexCentricQuery bq) {
            return BasicVertexCentricQueryBuilder.this.executeVertexIds(v, bq);
        }

        @Override
        public VertexList emptyResult() {
            return new VertexArrayList(BasicVertexCentricQueryBuilder.this.tx);
        }
    }

    protected class VertexConstructor
    implements ResultConstructor<Iterable<JanusGraphVertex>> {
        protected VertexConstructor() {
        }

        @Override
        public Iterable<JanusGraphVertex> getResult(InternalVertex v, BaseVertexCentricQuery bq) {
            return BasicVertexCentricQueryBuilder.this.executeVertices(v, bq);
        }

        @Override
        public Iterable<JanusGraphVertex> emptyResult() {
            return Collections.emptyList();
        }
    }

    protected class RelationConstructor
    implements ResultConstructor<Iterable<? extends JanusGraphRelation>> {
        protected RelationConstructor() {
        }

        @Override
        public Iterable<? extends JanusGraphRelation> getResult(InternalVertex v, BaseVertexCentricQuery bq) {
            return BasicVertexCentricQueryBuilder.this.executeRelations(v, bq);
        }

        @Override
        public Iterable<? extends JanusGraphRelation> emptyResult() {
            return Collections.emptyList();
        }
    }

    protected static interface ResultConstructor<Q> {
        public Q getResult(InternalVertex var1, BaseVertexCentricQuery var2);

        public Q emptyResult();
    }
}

