/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.keycolumnvalue.scan;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.function.Predicate;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeySlicesIterator;
import org.janusgraph.diskstorage.keycolumnvalue.MultiSlicesQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.scan.RowsCollector;
import org.janusgraph.diskstorage.keycolumnvalue.scan.StandardScannerExecutor;
import org.janusgraph.diskstorage.util.EntryArrayList;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingleThreadRowsCollector
extends RowsCollector {
    private static final Logger log = LoggerFactory.getLogger(SingleThreadRowsCollector.class);
    private final StoreTransaction storeTx;
    private final Predicate<StaticBuffer> keyFilter;
    private KeySlicesIterator keyIterator;
    private boolean interrupted = false;

    SingleThreadRowsCollector(KeyColumnValueStore store, StoreTransaction storeTx, List<SliceQuery> queries, Predicate<StaticBuffer> keyFilter, BlockingQueue<StandardScannerExecutor.Row> rowQueue) throws BackendException {
        super(store, rowQueue);
        this.storeTx = storeTx;
        this.keyFilter = keyFilter;
        this.setUp(queries);
    }

    private void setUp(List<SliceQuery> queries) throws BackendException {
        this.keyIterator = this.store.getKeys(new MultiSlicesQuery(queries), this.storeTx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void run() {
        try {
            while (!this.interrupted && this.keyIterator.hasNext()) {
                StaticBuffer key = (StaticBuffer)this.keyIterator.next();
                Map<SliceQuery, RecordIterator<Entry>> sliceToEntriesMap = this.keyIterator.getEntries();
                if (!this.keyFilter.test(key)) continue;
                HashMap<SliceQuery, EntryList> rowEntries = new HashMap<SliceQuery, EntryList>(sliceToEntriesMap.size());
                sliceToEntriesMap.forEach((sliceQuery, entryList) -> {
                    EntryList cfr_ignored_0 = rowEntries.put((SliceQuery)sliceQuery, EntryArrayList.of(entryList));
                });
                this.rowQueue.put(new StandardScannerExecutor.Row(key, rowEntries));
            }
        }
        catch (InterruptedException e) {
            log.error("Data-pulling thread interrupted while waiting on queue or data", (Throwable)e);
        }
        catch (Throwable e) {
            log.error("Could not load data from storage", e);
        }
        finally {
            try {
                this.keyIterator.close();
            }
            catch (IOException e) {
                log.warn("Could not close storage iterator ", (Throwable)e);
            }
        }
    }

    @Override
    void join() {
    }

    @Override
    void interrupt() {
        this.interrupted = true;
    }

    @Override
    void cleanup() throws PermanentBackendException {
        try {
            this.keyIterator.close();
        }
        catch (IOException e) {
            throw new PermanentBackendException(e);
        }
    }
}

