/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.KeyColumnValueStoreUtil;
import org.janusgraph.diskstorage.KeyValueStoreUtil;
import org.janusgraph.diskstorage.SimpleScanJob;
import org.janusgraph.diskstorage.SimpleScanJobRunner;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.cql.CQLStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.formats.cql.CqlInputFormat;
import org.janusgraph.hadoop.scan.CQLHadoopScanRunner;
import org.janusgraph.hadoop.scan.HadoopScanMapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CQLScanJobIT
extends JanusGraphBaseTest {
    @Container
    private static JanusGraphCassandraContainer cql = new JanusGraphCassandraContainer(true);
    private static final Logger log = LoggerFactory.getLogger(CQLScanJobIT.class);

    @Test
    public void testSimpleScan() throws InterruptedException, ExecutionException, IOException, BackendException {
        int keys = 1000;
        int cols = 40;
        String[][] values = KeyValueStoreUtil.generateData((int)keys, (int)cols);
        for (int i = 0; i < values.length; ++i) {
            if (i % 2 != 0) continue;
            values[i] = Arrays.copyOf(values[i], cols / 2);
        }
        log.debug("Loading values: " + keys + "x" + cols);
        CQLStoreManager mgr = new CQLStoreManager((Configuration)GraphDatabaseConfiguration.buildGraphConfiguration());
        KeyColumnValueStore store = mgr.openDatabase("edgestore");
        StoreTransaction tx = mgr.beginTransaction((BaseTransactionConfig)StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MICRO));
        KeyColumnValueStoreUtil.loadValues((KeyColumnValueStore)store, (StoreTransaction)tx, (String[][])values);
        tx.commit();
        SimpleScanJobRunner runner = (job, jobConf, rootNSName) -> {
            try {
                return ((CQLHadoopScanRunner)((CQLHadoopScanRunner)new CQLHadoopScanRunner(job).scanJobConf(jobConf)).scanJobConfRoot(rootNSName)).partitionerOverride("org.apache.cassandra.dht.Murmur3Partitioner").run();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
        SimpleScanJob.runBasicTests((int)keys, (int)cols, (SimpleScanJobRunner)runner);
    }

    @Test
    public void testPartitionedVertexScan() throws Exception {
        this.tearDown();
        CQLScanJobIT.clearGraph((WriteConfiguration)this.getConfiguration());
        WriteConfiguration partConf = this.getConfiguration();
        this.open(partConf);
        this.mgmt.makeVertexLabel("part").partition().make();
        this.finishSchema();
        JanusGraphVertex supernode = this.graph.addVertex("part");
        for (int i = 0; i < 128; ++i) {
            JanusGraphVertex v = this.graph.addVertex("part");
            v.addEdge("default", (Vertex)supernode, new Object[0]);
            if (0 >= i || 0 != i % 4) continue;
            this.graph.tx().commit();
        }
        this.graph.tx().commit();
        org.apache.hadoop.conf.Configuration c = new org.apache.hadoop.conf.Configuration();
        c.set(ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".storage.cql.keyspace", ((Object)((Object)this)).getClass().getSimpleName().toLowerCase());
        c.set(ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".storage.backend", "cql");
        c.set(ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".storage.port", String.valueOf(cql.getMappedCQLPort()));
        c.set("cassandra.input.partitioner.class", "org.apache.cassandra.dht.Murmur3Partitioner");
        Job job = this.getVertexJobWithDefaultMapper(c);
        Assertions.assertFalse((boolean)job.waitForCompletion(true));
    }

    @Test
    public void testPartitionedVertexFilteredScan() throws Exception {
        this.tearDown();
        CQLScanJobIT.clearGraph((WriteConfiguration)this.getConfiguration());
        WriteConfiguration partConf = this.getConfiguration();
        this.open(partConf);
        this.mgmt.makeVertexLabel("part").partition().make();
        this.finishSchema();
        JanusGraphVertex supernode = this.graph.addVertex("part");
        for (int i = 0; i < 128; ++i) {
            JanusGraphVertex v = this.graph.addVertex("part");
            v.addEdge("default", (Vertex)supernode, new Object[0]);
            if (0 >= i || 0 != i % 4) continue;
            this.graph.tx().commit();
        }
        this.graph.tx().commit();
        org.apache.hadoop.conf.Configuration c = new org.apache.hadoop.conf.Configuration();
        c.set(ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".storage.cql.keyspace", ((Object)((Object)this)).getClass().getSimpleName().toLowerCase());
        c.set(ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".storage.backend", "cql");
        c.set(ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + ".storage.port", String.valueOf(cql.getMappedCQLPort()));
        c.set(ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.FILTER_PARTITIONED_VERTICES, (boolean)true, (String[])new String[0]), "true");
        c.set("cassandra.input.partitioner.class", "org.apache.cassandra.dht.Murmur3Partitioner");
        Job job = this.getVertexJobWithDefaultMapper(c);
        Assertions.assertTrue((boolean)job.waitForCompletion(true));
    }

    private Job getVertexJobWithDefaultMapper(org.apache.hadoop.conf.Configuration c) throws IOException {
        Job job = Job.getInstance((org.apache.hadoop.conf.Configuration)c);
        job.setJarByClass(HadoopScanMapper.class);
        job.setJobName("testPartitionedVertexScan");
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setInputFormatClass(CqlInputFormat.class);
        return job;
    }

    public WriteConfiguration getConfiguration() {
        return cql.getConfiguration(((Object)((Object)this)).getClass().getSimpleName().toLowerCase()).getConfiguration();
    }
}

