/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.spark.process.computer.SparkGraphComputer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.hadoop.AbstractInputFormatIT;
import org.janusgraph.util.system.ConfigurationUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CQLInputFormatIT
extends AbstractInputFormatIT {
    @Container
    private static JanusGraphCassandraContainer cql = new JanusGraphCassandraContainer();

    private PropertiesConfiguration getGraphConfiguration(String filename) throws ConfigurationException, IOException {
        PropertiesConfiguration config = ConfigurationUtil.loadPropertiesConfig((String)filename, (boolean)false);
        Path baseOutDir = Paths.get((String)config.getProperty("gremlin.hadoop.outputLocation"), new String[0]);
        baseOutDir.toFile().mkdirs();
        String outDir = Files.createTempDirectory(baseOutDir, null, new FileAttribute[0]).toAbsolutePath().toString();
        config.setProperty("gremlin.hadoop.outputLocation", (Object)outDir);
        config.setProperty("janusgraphmr.ioformat.conf.storage.port", (Object)String.valueOf(cql.getMappedCQLPort()));
        return config;
    }

    public WriteConfiguration getConfiguration() {
        return cql.getConfiguration("cqlinputformatit").getConfiguration();
    }

    protected Graph getGraph() throws ConfigurationException, IOException {
        return GraphFactory.open((Configuration)this.getGraphConfiguration("target/test-classes/cql-read.properties"));
    }

    @Test
    public void testOpenFromConfigWithMultiHosts() throws ConfigurationException, IOException {
        Graph g = GraphFactory.open((Configuration)this.getGraphConfiguration("target/test-classes/cql-read-multi-hosts.properties"));
        this.runTraversalWithInvalidHost(g, "invalid-host");
    }

    @Test
    public void testOpenFromFileWithMultiHosts() {
        Graph g = GraphFactory.open((String)"target/test-classes/cql-read-multi-hosts.properties");
        this.runTraversalWithInvalidHost(g, "invalid-host");
    }

    private void runTraversalWithInvalidHost(Graph g, String hostname) {
        GraphTraversalSource t = g.traversal().withComputer(SparkGraphComputer.class);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> {
            Vertex cfr_ignored_0 = (Vertex)t.V(new Object[0]).next();
        });
        Assertions.assertEquals((Object)("java.lang.IllegalArgumentException: Failed to add contact point: " + hostname), (Object)exception.getMessage());
    }
}

