/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.hadoop.JanusGraphCustomIdSparkTest;
import org.janusgraph.util.system.ConfigurationUtil;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CQLCustomIdSparkTest
extends JanusGraphCustomIdSparkTest {
    @Container
    private static JanusGraphCassandraContainer cql = new JanusGraphCassandraContainer();

    private PropertiesConfiguration getSparkGraphConfiguration(String filename) throws ConfigurationException, IOException {
        PropertiesConfiguration config = ConfigurationUtil.loadPropertiesConfig((String)filename, (boolean)false);
        Path baseOutDir = Paths.get((String)config.getProperty("gremlin.hadoop.outputLocation"), new String[0]);
        baseOutDir.toFile().mkdirs();
        String outDir = Files.createTempDirectory(baseOutDir, null, new FileAttribute[0]).toAbsolutePath().toString();
        config.setProperty("gremlin.hadoop.outputLocation", (Object)outDir);
        config.setProperty("janusgraphmr.ioformat.conf.storage.port", (Object)String.valueOf(cql.getMappedCQLPort()));
        return config;
    }

    protected ModifiableConfiguration getModifiableConfiguration() {
        return cql.getConfiguration("cqlinputformatit");
    }

    protected Graph getSparkGraph() throws ConfigurationException, IOException {
        return GraphFactory.open((Configuration)this.getSparkGraphConfiguration("target/test-classes/cql-read.properties"));
    }
}

