/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.cql.customid;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CQLCustomDelimiterTest
extends JanusGraphBaseTest {
    @Container
    public static final JanusGraphCassandraContainer cqlContainer = new JanusGraphCassandraContainer();

    private static Map<String, String> getModifiableEnvironment() throws Exception {
        Class<?> pe = Class.forName("java.lang.ProcessEnvironment");
        Method getenv = pe.getDeclaredMethod("getenv", new Class[0]);
        getenv.setAccessible(true);
        Object unmodifiableEnvironment = getenv.invoke(null, new Object[0]);
        Class<?> map = Class.forName("java.util.Collections$UnmodifiableMap");
        Field m = map.getDeclaredField("m");
        m.setAccessible(true);
        return (Map)m.get(unmodifiableEnvironment);
    }

    @Test
    public void testCustomRelationDelimiter() throws Exception {
        Map<String, String> env = CQLCustomDelimiterTest.getModifiableEnvironment();
        env.put("JANUSGRAPH_RELATION_DELIMITER", "@");
        this.clopen(new Object[]{CQLCustomDelimiterTest.option((ConfigOption)GraphDatabaseConfiguration.ALLOW_SETTING_VERTEX_ID, (String[])new String[0]), true, CQLCustomDelimiterTest.option((ConfigOption)GraphDatabaseConfiguration.ALLOW_CUSTOM_VERTEX_ID_TYPES, (String[])new String[0]), true});
        String id1 = UUID.randomUUID().toString();
        String id2 = UUID.randomUUID().toString();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[]{T.id, id1, "prop", "val"});
        JanusGraphVertex v2 = this.graph.addVertex(new Object[]{T.id, id2, "prop", "val"});
        this.graph.traversal().addE("link").from((Vertex)v1).to((Vertex)v2).property((Object)"count", (Object)1, new Object[0]).next();
        this.graph.tx().commit();
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().E(new Object[0]).count().next()));
        Edge edge = (Edge)this.graph.traversal().E(new Object[0]).has("count", (Object)1).next();
        Assertions.assertEquals((Object)id1, (Object)edge.outVertex().id());
        Assertions.assertEquals((Object)id2, (Object)edge.inVertex().id());
        env.remove("JANUSGRAPH_RELATION_DELIMITER");
    }

    public WriteConfiguration getConfiguration() {
        return cqlContainer.getConfiguration(((Object)((Object)this)).getClass().getSimpleName()).getConfiguration();
    }
}

