/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.cql;

import io.github.artsok.ParameterizedRepeatedIfExceptionsTest;
import io.github.artsok.RepeatedIfExceptionsTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.util.backpressure.SemaphoreQueryBackPressure;
import org.janusgraph.graphdb.JanusGraphTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryPropertiesStrategyMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CQLGraphTest
extends JanusGraphTest {
    private final Logger log = LoggerFactory.getLogger(CQLGraphTest.class);
    @Container
    public static final JanusGraphCassandraContainer cqlContainer = new JanusGraphCassandraContainer();

    protected static Stream<Arguments> generateSemaphoreBackPressureConfigs() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{0, "semaphore"}), Arguments.arguments((Object[])new Object[]{1, "semaphore"}), Arguments.arguments((Object[])new Object[]{2, "semaphore"}), Arguments.arguments((Object[])new Object[]{3, "semaphore"}), Arguments.arguments((Object[])new Object[]{10, "semaphore"}), Arguments.arguments((Object[])new Object[]{100, "semaphore"}), Arguments.arguments((Object[])new Object[]{1000, "semaphore"}), Arguments.arguments((Object[])new Object[]{1500, "semaphore"}), Arguments.arguments((Object[])new Object[]{0, "semaphoreReleaseProtected"}), Arguments.arguments((Object[])new Object[]{1, "semaphoreReleaseProtected"}), Arguments.arguments((Object[])new Object[]{2, "semaphoreReleaseProtected"}), Arguments.arguments((Object[])new Object[]{3, "semaphoreReleaseProtected"}), Arguments.arguments((Object[])new Object[]{10, "semaphoreReleaseProtected"}), Arguments.arguments((Object[])new Object[]{100, "semaphoreReleaseProtected"}), Arguments.arguments((Object[])new Object[]{1000, "semaphoreReleaseProtected"}), Arguments.arguments((Object[])new Object[]{1500, "semaphoreReleaseProtected"})});
    }

    protected static Stream<Arguments> generateGroupingConfigs() {
        boolean keysGroupingAllowed = JanusGraphCassandraContainer.supportsPerPartitionLimit();
        ArrayList<Arguments> argumentsList = new ArrayList<Arguments>();
        if (keysGroupingAllowed) {
            argumentsList.add(Arguments.arguments((Object[])new Object[]{1, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
            argumentsList.add(Arguments.arguments((Object[])new Object[]{100, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
            argumentsList.add(Arguments.arguments((Object[])new Object[]{2000, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
            argumentsList.add(Arguments.arguments((Object[])new Object[]{1, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 200}}));
            argumentsList.add(Arguments.arguments((Object[])new Object[]{100, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 200}}));
            argumentsList.add(Arguments.arguments((Object[])new Object[]{2000, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 200}}));
            argumentsList.add(Arguments.arguments((Object[])new Object[]{1, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
            argumentsList.add(Arguments.arguments((Object[])new Object[]{100, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
            argumentsList.add(Arguments.arguments((Object[])new Object[]{2000, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
        }
        argumentsList.add(Arguments.arguments((Object[])new Object[]{1, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
        argumentsList.add(Arguments.arguments((Object[])new Object[]{100, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
        argumentsList.add(Arguments.arguments((Object[])new Object[]{2000, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
        argumentsList.add(Arguments.arguments((Object[])new Object[]{1, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
        argumentsList.add(Arguments.arguments((Object[])new Object[]{100, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
        argumentsList.add(Arguments.arguments((Object[])new Object[]{2000, new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_LIMIT, (String[])new String[0]), 100, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_MIN, (String[])new String[0]), 2}}));
        return argumentsList.stream();
    }

    public WriteConfiguration getConfiguration() {
        return cqlContainer.getConfiguration(((Object)((Object)this)).getClass().getSimpleName()).getConfiguration();
    }

    @Test
    public void testHasTTL() {
        Assertions.assertTrue((boolean)this.features.hasCellTTL());
    }

    @ParameterizedRepeatedIfExceptionsTest(repeats=3)
    @ValueSource(booleans={true, false})
    public void simpleLogTest(boolean useStringId) throws InterruptedException {
        super.simpleLogTest(useStringId);
    }

    @ParameterizedRepeatedIfExceptionsTest(repeats=3)
    @ValueSource(booleans={true, false})
    public void simpleLogTestWithFailure(boolean useStringId) throws InterruptedException {
        super.simpleLogTestWithFailure(useStringId);
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testEdgeTTLTiming() throws Exception {
        super.testEdgeTTLTiming();
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testVertexTTLWithCompositeIndex() throws Exception {
        super.testVertexTTLWithCompositeIndex();
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testVertexTTLImplicitKey() throws Exception {
        super.testVertexTTLImplicitKey();
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testReindexingForEdgeIndex() throws ExecutionException, InterruptedException {
        super.testReindexingForEdgeIndex();
    }

    protected static Stream<Arguments> generateConsistencyConfigs() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{true, true, 20}), Arguments.arguments((Object[])new Object[]{true, false, 20}), Arguments.arguments((Object[])new Object[]{true, false, 1}), Arguments.arguments((Object[])new Object[]{false, true, 20}), Arguments.arguments((Object[])new Object[]{false, false, 20}), Arguments.arguments((Object[])new Object[]{false, false, 1})});
    }

    @Test
    @Disabled
    public void testConsistencyEnforcement() {
    }

    @ParameterizedTest
    @MethodSource(value={"generateConsistencyConfigs"})
    public void testConsistencyEnforcement(boolean assignTimestamp, boolean atomicBatch, int batchSize) {
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.ASSIGN_TIMESTAMP, (String[])new String[0]), assignTimestamp, CQLGraphTest.option((ConfigOption)CQLConfigOptions.ATOMIC_BATCH_MUTATE, (String[])new String[0]), atomicBatch, CQLGraphTest.option((ConfigOption)CQLConfigOptions.BATCH_STATEMENT_SIZE, (String[])new String[0]), batchSize});
        super.testConsistencyEnforcement();
    }

    @Test
    @Disabled
    public void testConcurrentConsistencyEnforcement() {
    }

    @ParameterizedTest
    @MethodSource(value={"generateConsistencyConfigs"})
    public void testConcurrentConsistencyEnforcement(boolean assignTimestamp, boolean atomicBatch, int batchSize) throws Exception {
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.ASSIGN_TIMESTAMP, (String[])new String[0]), assignTimestamp, CQLGraphTest.option((ConfigOption)CQLConfigOptions.ATOMIC_BATCH_MUTATE, (String[])new String[0]), atomicBatch, CQLGraphTest.option((ConfigOption)CQLConfigOptions.BATCH_STATEMENT_SIZE, (String[])new String[0]), batchSize});
        super.testConcurrentConsistencyEnforcement();
    }

    @Test
    public void testQueryLongForPropertyKey() {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("nameIndex", Vertex.class).addKey(name).buildCompositeIndex();
        this.finishSchema();
        String testName = RandomStringUtils.random((int)100000, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(0L));
        GraphTraversalSource g = this.graph.traversal();
        JanusGraphException ex = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> g.V(new Object[0]).has("name", (Object)testName).hasNext());
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)ex, TemporaryBackendException.class), (String)"Query should not produce a TemporaryBackendException");
        Assertions.assertNotEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)ex, PermanentBackendException.class), (String)"Query should produce a PermanentBackendException");
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 3, 10, 100, 1000})
    public void fetchElementsUsingDifferentPageSize(int pageSize) {
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PAGE_SIZE, (String[])new String[0]), pageSize});
        this.assertSingleTxAdditionAndCount(10, pageSize * 3);
    }

    @ParameterizedTest
    @MethodSource(value={"generateSemaphoreBackPressureConfigs"})
    public void testDifferentBackpressureLimitIsApplicable(int backPressureLimit, String backPressureClass) {
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)CQLConfigOptions.BACK_PRESSURE_LIMIT, (String[])new String[0]), backPressureLimit, CQLGraphTest.option((ConfigOption)CQLConfigOptions.BACK_PRESSURE_CLASS, (String[])new String[0]), backPressureClass, CQLGraphTest.option((ConfigOption)CQLConfigOptions.MAX_REQUESTS_PER_CONNECTION, (String[])new String[0]), Math.max((Integer)CQLConfigOptions.MAX_REQUESTS_PER_CONNECTION.getDefaultValue(), backPressureLimit), CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true});
        this.assertSingleTxAdditionAndCount(10, 20);
    }

    @Test
    public void testBackpressureIsDisabled() {
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)CQLConfigOptions.BACK_PRESSURE_CLASS, (String[])new String[0]), "passAll", CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.MAX_REQUESTS_PER_CONNECTION, (String[])new String[0]), 1024, CQLGraphTest.option((ConfigOption)CQLConfigOptions.LOCAL_MAX_CONNECTIONS_PER_HOST, (String[])new String[0]), 20, CQLGraphTest.option((ConfigOption)CQLConfigOptions.REMOTE_MAX_CONNECTIONS_PER_HOST, (String[])new String[0]), 1});
        this.assertSingleTxAdditionAndCount(10, 20);
    }

    @Test
    public void testCustomBackPressureClassIsSet() {
        CustomQueryBackPressure.acquireIsUsed = false;
        CustomQueryBackPressure.releaseIsUsed = false;
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)CQLConfigOptions.BACK_PRESSURE_CLASS, (String[])new String[0]), CustomQueryBackPressure.class.getName(), CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true});
        this.assertSingleTxAdditionAndCount(10, 20);
        Assertions.assertTrue((boolean)CustomQueryBackPressure.acquireIsUsed);
        Assertions.assertTrue((boolean)CustomQueryBackPressure.releaseIsUsed);
    }

    @Test
    @Disabled(value="Use Parametrized test instead")
    public void testLimitBatchSizeForMultiQueryMultiCardinalityProperties() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testLimitBatchSizeForMultiQueryMultiCardinalityProperties(boolean sliceGroupingAllowed) {
        JanusGraphVertex[] cs = this.setupDataForMultiQueryMultiCardinalityProperties();
        int barrierSize = 27;
        TraversalMetrics profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo", "setProperty", "listProperty"}), new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), sliceGroupingAllowed});
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize + barrierSize * 4 + barrierSize * 4, profile.getMetrics()));
        int lastBatch = cs.length - 3 * barrierSize;
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(lastBatch + lastBatch * 4 + lastBatch * 4, profile.getMetrics()));
    }

    @MethodSource(value={"generateGroupingConfigs"})
    @ParameterizedTest
    public void testBatchWithCQLGrouping(int elementsAmount, Object[] configuration) {
        this.mgmt.makeVertexLabel("testVertex").make();
        this.mgmt.makePropertyKey("singleProperty1").cardinality(Cardinality.SINGLE).dataType(String.class).make();
        this.mgmt.makePropertyKey("singleProperty2").cardinality(Cardinality.SINGLE).dataType(String.class).make();
        this.mgmt.makePropertyKey("singleProperty3").cardinality(Cardinality.SINGLE).dataType(String.class).make();
        this.mgmt.makePropertyKey("setProperty").cardinality(Cardinality.SET).dataType(String.class).make();
        this.mgmt.makePropertyKey("listProperty").cardinality(Cardinality.LIST).dataType(String.class).make();
        this.finishSchema();
        JanusGraphVertex[] cs = new JanusGraphVertex[elementsAmount];
        for (int i = 0; i < elementsAmount; ++i) {
            cs[i] = this.graph.addVertex("testVertex");
            cs[i].property("singleProperty1", (Object)("single value1 " + i));
            cs[i].property("singleProperty2", (Object)("single value1 " + i));
            cs[i].property("singleProperty3", (Object)("single value1 " + i));
            cs[i].property(VertexProperty.Cardinality.set, "setProperty", (Object)"setValue1", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.set, "setProperty", (Object)"setValue2", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.set, "setProperty", (Object)"setValue3", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.set, "setProperty", (Object)"setValue4", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.list, "listProperty", (Object)"listValue1", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.list, "listProperty", (Object)"listValue2", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.list, "listProperty", (Object)"listValue3", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.list, "listProperty", (Object)"listValue4", new Object[0]);
        }
        this.newTx();
        this.clopen(configuration);
        TraversalMetrics profile = this.testGroupingBatch(() -> this.graph.traversal().V((Object[])cs).barrier(elementsAmount).values(new String[]{"singleProperty1", "singleProperty2", "singleProperty3", "setProperty", "listProperty"}), configuration);
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(elementsAmount * 11, profile.getMetrics()));
    }

    protected TraversalMetrics testGroupingBatch(Supplier<GraphTraversal<?, ?>> traversal, Object ... settings) {
        this.clopen(settings);
        List resultWithConfiguredOptions = traversal.get().toList();
        if (JanusGraphCassandraContainer.supportsPerPartitionLimit()) {
            this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_CLASS, (String[])new String[0]), "replicasAware"});
            List resultWithKeysEnabledSliceEnabledReplicasAware = traversal.get().toList();
            Assertions.assertEquals((Object)resultWithKeysEnabledSliceEnabledReplicasAware, (Object)resultWithConfiguredOptions);
            this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_CLASS, (String[])new String[0]), "replicasAware"});
            List resultWithKeysEnabledSliceDisabledReplicasAware = traversal.get().toList();
            Assertions.assertEquals((Object)resultWithKeysEnabledSliceDisabledReplicasAware, (Object)resultWithConfiguredOptions);
            this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_CLASS, (String[])new String[0]), "tokenRangeAware"});
            List resultWithKeysEnabledSliceEnabledTokenRangeAware = traversal.get().toList();
            Assertions.assertEquals((Object)resultWithKeysEnabledSliceEnabledTokenRangeAware, (Object)resultWithConfiguredOptions);
            this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_CLASS, (String[])new String[0]), "tokenRangeAware"});
            List resultWithKeysEnabledSliceDisabledTokenRangeAware = traversal.get().toList();
            Assertions.assertEquals((Object)resultWithKeysEnabledSliceDisabledTokenRangeAware, (Object)resultWithConfiguredOptions);
        }
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), false});
        List resultWithKeysDisabledSliceEnabled = traversal.get().toList();
        Assertions.assertEquals((Object)resultWithKeysDisabledSliceEnabled, (Object)resultWithConfiguredOptions);
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (String[])new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.KEYS_GROUPING_ALLOWED, (String[])new String[0]), false});
        List resultWithKeysDisabledSliceDisabled = traversal.get().toList();
        Assertions.assertEquals((Object)resultWithKeysDisabledSliceDisabled, (Object)resultWithConfiguredOptions);
        this.clopen(settings);
        return (TraversalMetrics)traversal.get().profile().next();
    }

    @Test
    @Disabled(value="Use Parametrized test instead")
    public void testMultiQueryPropertiesWithLimit() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testMultiQueryPropertiesWithLimit(boolean sliceGroupingAllowed) {
        JanusGraphVertex[] cs = this.setupDataForMultiQueryMultiCardinalityProperties();
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), sliceGroupingAllowed});
        this.verityMultiQueryPropertiesWithLimit(cs);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 10, 100, 1000, 0x7FFFFFFF})
    public void testMultiQuerySliceGroupingLimit(int sliceGroupingLimit) {
        int j;
        int propsCount;
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.USE_MULTIQUERY, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.LIMITED_BATCH, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (String[])new String[0]), false, CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_ALLOWED, (String[])new String[0]), true, CQLGraphTest.option((ConfigOption)CQLConfigOptions.SLICE_GROUPING_LIMIT, (String[])new String[0]), sliceGroupingLimit});
        this.mgmt.makeVertexLabel("testVertex").make();
        this.finishSchema();
        int numV = 100;
        int n = propsCount = sliceGroupingLimit > 100 ? 100 : sliceGroupingLimit * 3;
        if (propsCount == 0) {
            propsCount = 1;
        }
        Object[] cs = new JanusGraphVertex[numV];
        for (int i = 0; i < numV; ++i) {
            cs[i] = this.graph.addVertex("testVertex");
            for (j = 0; j < propsCount; ++j) {
                cs[i].property("foo" + j, (Object)("bar" + j));
            }
        }
        this.newTx();
        cs = this.graph.traversal().V(cs).toList().toArray(new JanusGraphVertex[0]);
        String[] keys = new String[propsCount];
        for (j = 0; j < propsCount; ++j) {
            keys[j] = "foo" + j;
        }
        for (Integer limit : Arrays.asList(1, 2, 3, 5, 10, 15, 100, 150, 1000, 2000, 2147483547)) {
            Map properties = this.graph.multiQuery(new JanusGraphVertex[]{cs[0], cs[1], cs[3]}).limit(limit.intValue()).keys(keys).properties();
            HashMap deserializedProperties = new HashMap();
            Assertions.assertEquals((int)3, (int)properties.size());
            properties.forEach((janusGraphVertex, janusGraphVertexProperties) -> {
                HashMap props = new HashMap();
                janusGraphVertexProperties.forEach(janusGraphVertexProperty -> ((ArrayList)props.computeIfAbsent(janusGraphVertexProperty.key(), k -> new ArrayList())).add(janusGraphVertexProperty.value()));
                deserializedProperties.put(janusGraphVertex, props);
            });
            for (Map vertexProps : deserializedProperties.values()) {
                int numOfValues = 0;
                for (Object val : vertexProps.values()) {
                    numOfValues += ((List)val).size();
                }
                Assertions.assertEquals((int)Math.min(propsCount, limit), (int)numOfValues);
            }
        }
    }

    private void assertSingleTxAdditionAndCount(int indexedVerticesCount, int adjacentVerticesCount) {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("nameIndex", Vertex.class).addKey(name).buildCompositeIndex();
        this.mgmt.makeEdgeLabel("testEdge").multiplicity(Multiplicity.SIMPLE).make();
        this.finishSchema();
        GraphTraversalSource g = this.graph.traversal();
        for (int i = 0; i < indexedVerticesCount; ++i) {
            Vertex indexedVertex = (Vertex)g.addV().property((Object)"name", (Object)"testName", new Object[0]).next();
            for (int j = 0; j < adjacentVerticesCount; ++j) {
                Vertex adjacentVertex = (Vertex)g.addV().next();
                indexedVertex.addEdge("testEdge", adjacentVertex, new Object[0]);
            }
        }
        g.tx().commit();
        int idsCount = g.V(new Object[0]).has("name", (Object)"testName").out(new String[]{"testEdge"}).id().toList().size();
        Assertions.assertEquals((int)(indexedVerticesCount * adjacentVerticesCount), (int)idsCount);
    }

    public static class CustomQueryBackPressure
    extends SemaphoreQueryBackPressure {
        public static volatile boolean acquireIsUsed;
        public static volatile boolean releaseIsUsed;

        public CustomQueryBackPressure(Configuration configuration, Integer backPressureLimit) {
            super(backPressureLimit.intValue());
        }

        public void acquireBeforeQuery() {
            acquireIsUsed = true;
            super.acquireBeforeQuery();
        }

        public void releaseAfterQuery() {
            releaseIsUsed = true;
            super.releaseAfterQuery();
        }
    }
}

