/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.cql;

import io.github.artsok.ParameterizedRepeatedIfExceptionsTest;
import io.github.artsok.RepeatedIfExceptionsTest;
import java.util.concurrent.ExecutionException;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.StorageSetup;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.JanusGraphTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CQLGraphCacheTest
extends JanusGraphTest {
    @Container
    public static final JanusGraphCassandraContainer cqlContainer = new JanusGraphCassandraContainer();

    public WriteConfiguration getConfiguration() {
        return StorageSetup.addPermanentCache((ModifiableConfiguration)cqlContainer.getConfiguration(((Object)((Object)this)).getClass().getSimpleName()));
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testIndexUpdatesWithReindexAndRemove() throws InterruptedException, ExecutionException {
        super.testIndexUpdatesWithReindexAndRemove();
    }

    @ParameterizedRepeatedIfExceptionsTest(repeats=3)
    @ValueSource(booleans={true, false})
    public void simpleLogTest(boolean useStringId) throws InterruptedException {
        super.simpleLogTest(useStringId);
    }

    @ParameterizedRepeatedIfExceptionsTest(repeats=3)
    @ValueSource(booleans={true, false})
    public void simpleLogTestWithFailure(boolean useStringId) throws InterruptedException {
        super.simpleLogTestWithFailure(useStringId);
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testEdgeTTLTiming() throws Exception {
        super.testEdgeTTLTiming();
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testEdgeTTLWithTransactions() throws Exception {
        super.testEdgeTTLWithTransactions();
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testVertexTTLWithCompositeIndex() throws Exception {
        super.testVertexTTLWithCompositeIndex();
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testVertexTTLImplicitKey() throws Exception {
        super.testVertexTTLImplicitKey();
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testReindexingForEdgeIndex() throws ExecutionException, InterruptedException {
        super.testReindexingForEdgeIndex();
    }
}

