/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.strategy;

import java.util.List;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLStoreManager;
import org.janusgraph.diskstorage.cql.strategy.GroupedExecutionStrategy;
import org.janusgraph.diskstorage.cql.strategy.GroupedExecutionStrategyBuilder;
import org.janusgraph.diskstorage.cql.strategy.ReplicasAwareGroupedExecutionStrategy;
import org.janusgraph.diskstorage.cql.strategy.ResultFiller;
import org.janusgraph.diskstorage.cql.strategy.TokenRangeAwareGroupedExecutionStrategy;
import org.janusgraph.diskstorage.cql.util.KeysGroup;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class GroupedExecutionStrategyBuilderTest {
    @Test
    public void shouldBuildTokenRangeAwareStrategy() {
        GroupedExecutionStrategy strategy = GroupedExecutionStrategyBuilder.build(null, (CQLStoreManager)((CQLStoreManager)Mockito.mock(CQLStoreManager.class)), (String)"tokenRangeAware");
        Assertions.assertEquals(TokenRangeAwareGroupedExecutionStrategy.class, strategy.getClass());
    }

    @Test
    public void shouldBuildReplicasAwareStrategy() {
        CQLStoreManager storeManager = (CQLStoreManager)Mockito.mock(CQLStoreManager.class);
        Mockito.when((Object)storeManager.getKeyspaceName()).thenReturn((Object)"testKeyspace");
        GroupedExecutionStrategy strategy = GroupedExecutionStrategyBuilder.build(null, (CQLStoreManager)storeManager, (String)"replicasAware");
        Assertions.assertEquals(ReplicasAwareGroupedExecutionStrategy.class, strategy.getClass());
    }

    @Test
    public void shouldBuildSpecificStrategy() {
        GroupedExecutionStrategy strategy = GroupedExecutionStrategyBuilder.build(null, (CQLStoreManager)((CQLStoreManager)Mockito.mock(CQLStoreManager.class)), (String)TestGroupedExecutionStrategy.class.getName());
        Assertions.assertEquals(TestGroupedExecutionStrategy.class, strategy.getClass());
    }

    @Test
    public void shouldFailBuildCustomStrategyWhichThrowsException() {
        Assertions.assertThrows(IllegalStateException.class, () -> GroupedExecutionStrategyBuilder.build(null, (CQLStoreManager)((CQLStoreManager)Mockito.mock(CQLStoreManager.class)), (String)TestFailingGroupedExecutionStrategy.class.getName()));
    }

    @Test
    public void shouldFailBuildCustomStrategyWithoutNecessaryConstructor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> GroupedExecutionStrategyBuilder.build(null, (CQLStoreManager)((CQLStoreManager)Mockito.mock(CQLStoreManager.class)), (String)TestNoArgsGroupedExecutionStrategy.class.getName()));
    }

    @Test
    public void shouldFailBuildNonExistingClass() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> GroupedExecutionStrategyBuilder.build(null, (CQLStoreManager)((CQLStoreManager)Mockito.mock(CQLStoreManager.class)), (String)"NonExistingStrategyImplementation"));
    }

    @Test
    public void shouldFailBuildIfNotImplementsProperInterface() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> GroupedExecutionStrategyBuilder.build(null, (CQLStoreManager)((CQLStoreManager)Mockito.mock(CQLStoreManager.class)), (String)Integer.class.getName()));
    }

    private static class TestFailingGroupedExecutionStrategy
    implements GroupedExecutionStrategy {
        public TestFailingGroupedExecutionStrategy(Configuration configuration, CQLStoreManager storeManager) {
            throw new RuntimeException();
        }

        public <R, Q> void execute(R futureResult, Q queries, List<StaticBuffer> keys, ResultFiller<R, Q, KeysGroup> withKeysGroupingFiller, ResultFiller<R, Q, List<StaticBuffer>> withoutKeysGroupingFiller, StoreTransaction txh, int keysGroupingLimit) {
        }
    }

    public static class TestNoArgsGroupedExecutionStrategy
    implements GroupedExecutionStrategy {
        public <R, Q> void execute(R futureResult, Q queries, List<StaticBuffer> keys, ResultFiller<R, Q, KeysGroup> withKeysGroupingFiller, ResultFiller<R, Q, List<StaticBuffer>> withoutKeysGroupingFiller, StoreTransaction txh, int keysGroupingLimit) {
        }
    }

    private static class TestGroupedExecutionStrategy
    implements GroupedExecutionStrategy {
        public TestGroupedExecutionStrategy(Configuration configuration, CQLStoreManager session) {
        }

        public <R, Q> void execute(R futureResult, Q queries, List<StaticBuffer> keys, ResultFiller<R, Q, KeysGroup> withKeysGroupingFiller, ResultFiller<R, Q, List<StaticBuffer>> withoutKeysGroupingFiller, StoreTransaction txh, int keysGroupingLimit) {
        }
    }
}

