/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.oss.driver.api.core.AsyncAutoCloseable;
import com.datastax.oss.driver.api.core.CqlSession;
import java.util.HashMap;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLStoreManager;
import org.janusgraph.diskstorage.cql.CachingCQLSessionBuilder;
import org.janusgraph.diskstorage.cql.builder.CQLSessionBuilder;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class CachingCQLStoreManager
extends CQLStoreManager {
    private static final Map<String, CqlSession> sessions = new HashMap<String, CqlSession>();

    public CachingCQLStoreManager(Configuration configuration) throws BackendException {
        super(configuration, DEFAULT_MUTATE_MANY_FUNCTION_BUILDER, DEFAULT_STORE_FEATURES_BUILDER, (CQLSessionBuilder)new CachingCQLSessionBuilder(sessions, CachingCQLStoreManager.determineKeyspaceName((Configuration)configuration)), DEFAULT_PROGRAMMATIC_CONFIGURATION_LOADER_BUILDER);
    }

    public void close() {
        if (((Boolean)this.storageConfig.get(GraphDatabaseConfiguration.DROP_ON_CLEAR, new String[0])).booleanValue()) {
            sessions.values().forEach(AsyncAutoCloseable::close);
            sessions.clear();
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }
}

