/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import io.vavr.Function1;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.Array;
import io.vavr.collection.Iterator;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.function.Function;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.cql.CQLColValGetter;
import org.janusgraph.diskstorage.cql.CQLResultSetKeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CQLResultSetKeyIteratorTest {
    private static final SliceQuery ALL_COLUMNS = new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)128));

    @Test
    public void testIterator() throws IOException {
        Array rows = Array.rangeClosed((int)1, (int)100).map(idx -> {
            Row row = (Row)Mockito.mock(Row.class);
            Mockito.when((Object)row.getByteBuffer("key")).thenReturn((Object)ByteBuffer.wrap(Integer.toString(idx / 5).getBytes()));
            Mockito.when((Object)row.getByteBuffer("column1")).thenReturn((Object)ByteBuffer.wrap(Integer.toString(idx % 5).getBytes()));
            Mockito.when((Object)row.getByteBuffer("value")).thenReturn((Object)ByteBuffer.wrap(Integer.toString(idx).getBytes()));
            return row;
        });
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.iterator()).thenReturn((Object)rows.iterator());
        CQLColValGetter getter = new CQLColValGetter(new EntryMetaData[0]);
        try (CQLResultSetKeyIterator resultSetKeyIterator = new CQLResultSetKeyIterator(ALL_COLUMNS, getter, (Iterable)resultSet);){
            int i = 0;
            while (resultSetKeyIterator.hasNext()) {
                StaticBuffer next = (StaticBuffer)resultSetKeyIterator.next();
                RecordIterator entries = resultSetKeyIterator.getEntries();
                while (entries.hasNext()) {
                    Row row = (Row)rows.get(i++);
                    Entry entry = (Entry)entries.next();
                    Assertions.assertEquals((Object)row.getByteBuffer("key"), (Object)next.asByteBuffer());
                    Assertions.assertEquals((Object)row.getByteBuffer("column1"), (Object)entry.getColumn().asByteBuffer());
                    Assertions.assertEquals((Object)row.getByteBuffer("value"), (Object)entry.getValue().asByteBuffer());
                }
            }
        }
    }

    @Test
    public void testEmpty() throws IOException {
        Array rows = Array.empty();
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.iterator()).thenReturn((Object)rows.iterator());
        CQLColValGetter getter = new CQLColValGetter(new EntryMetaData[0]);
        try (CQLResultSetKeyIterator resultSetKeyIterator = new CQLResultSetKeyIterator(ALL_COLUMNS, getter, (Iterable)resultSet);){
            Assertions.assertFalse((boolean)resultSetKeyIterator.hasNext());
        }
    }

    @Test
    public void testUneven() throws IOException {
        Array<Tuple2<ByteBuffer, Array<Tuple2<ByteBuffer, ByteBuffer>>>> keysMap = this.generateRandomKeysMap();
        ResultSet resultSet = this.generateMockedResultSet(keysMap);
        CQLColValGetter getter = new CQLColValGetter(new EntryMetaData[0]);
        try (CQLResultSetKeyIterator resultSetKeyIterator = new CQLResultSetKeyIterator(ALL_COLUMNS, getter, (Iterable)resultSet);){
            Iterator iterator = keysMap.iterator();
            while (resultSetKeyIterator.hasNext()) {
                StaticBuffer next = (StaticBuffer)resultSetKeyIterator.next();
                RecordIterator entries = resultSetKeyIterator.getEntries();
                Throwable throwable = null;
                try {
                    Tuple2 current = (Tuple2)iterator.next();
                    ByteBuffer currentKey = (ByteBuffer)current._1;
                    Array columnValues = (Array)current._2;
                    Iterator columnIterator = columnValues.iterator();
                    while (entries.hasNext()) {
                        Entry entry = (Entry)entries.next();
                        Tuple2 columnAndValue = (Tuple2)columnIterator.next();
                        Assertions.assertEquals((Object)currentKey, (Object)next.asByteBuffer());
                        Assertions.assertEquals((Object)columnAndValue._1, (Object)entry.getColumn().asByteBuffer());
                        Assertions.assertEquals((Object)columnAndValue._2, (Object)entry.getValue().asByteBuffer());
                        Assertions.assertEquals((Object)columnIterator.hasNext(), (Object)entries.hasNext());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entries == null) continue;
                    if (throwable != null) {
                        try {
                            entries.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    entries.close();
                }
            }
        }
    }

    @Test
    public void testPartialIterateColumns() throws IOException {
        Random random = new Random();
        Array<Tuple2<ByteBuffer, Array<Tuple2<ByteBuffer, ByteBuffer>>>> keysMap = this.generateRandomKeysMap();
        ResultSet resultSet = this.generateMockedResultSet(keysMap);
        CQLColValGetter getter = new CQLColValGetter(new EntryMetaData[0]);
        try (CQLResultSetKeyIterator resultSetKeyIterator = new CQLResultSetKeyIterator(ALL_COLUMNS, getter, (Iterable)resultSet);){
            Iterator iterator = keysMap.iterator();
            block18: while (resultSetKeyIterator.hasNext()) {
                StaticBuffer next = (StaticBuffer)resultSetKeyIterator.next();
                RecordIterator entries = resultSetKeyIterator.getEntries();
                Throwable throwable = null;
                try {
                    Tuple2 current = (Tuple2)iterator.next();
                    ByteBuffer currentKey = (ByteBuffer)current._1;
                    Array columnValues = (Array)current._2;
                    Iterator columnIterator = columnValues.iterator();
                    while (entries.hasNext()) {
                        Entry entry = (Entry)entries.next();
                        Tuple2 columnAndValue = (Tuple2)columnIterator.next();
                        Assertions.assertEquals((Object)currentKey, (Object)next.asByteBuffer());
                        Assertions.assertEquals((Object)columnAndValue._1, (Object)entry.getColumn().asByteBuffer());
                        Assertions.assertEquals((Object)columnAndValue._2, (Object)entry.getValue().asByteBuffer());
                        Assertions.assertEquals((Object)columnIterator.hasNext(), (Object)entries.hasNext());
                        if (random.nextInt(10) != 0) continue;
                        continue block18;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (entries == null) continue;
                    if (throwable != null) {
                        try {
                            entries.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    entries.close();
                }
            }
        }
    }

    @Test
    public void testNoIterateColumns() throws IOException {
        Array<Tuple2<ByteBuffer, Array<Tuple2<ByteBuffer, ByteBuffer>>>> keysMap = this.generateRandomKeysMap();
        ResultSet resultSet = this.generateMockedResultSet(keysMap);
        CQLColValGetter getter = new CQLColValGetter(new EntryMetaData[0]);
        try (CQLResultSetKeyIterator resultSetKeyIterator = new CQLResultSetKeyIterator(ALL_COLUMNS, getter, (Iterable)resultSet);){
            Iterator iterator = keysMap.iterator();
            while (resultSetKeyIterator.hasNext()) {
                StaticBuffer next = (StaticBuffer)resultSetKeyIterator.next();
                Assertions.assertEquals((Object)((Tuple2)iterator.next())._1, (Object)next.asByteBuffer());
            }
        }
    }

    private Array<Tuple2<ByteBuffer, Array<Tuple2<ByteBuffer, ByteBuffer>>>> generateRandomKeysMap() {
        Random random = new Random();
        Function1 & Serializable randomLong = (Function1 & Serializable)idx -> {
            ByteBuffer buffer = ByteBuffer.allocate(8).putLong(random.nextLong());
            buffer.flip();
            return buffer;
        };
        return Array.range((int)0, (int)(random.nextInt(100) + 100)).map((Function)randomLong).map(key -> Tuple.of((Object)key, (Object)Array.rangeClosed((int)0, (int)(random.nextInt(100) + 1)).map(idx -> Tuple.of((Object)randomLong.apply(idx), (Object)randomLong.apply(idx)))));
    }

    private ResultSet generateMockedResultSet(Array<Tuple2<ByteBuffer, Array<Tuple2<ByteBuffer, ByteBuffer>>>> keysMap) {
        Array rows = keysMap.flatMap(tuple -> ((Array)tuple._2).map(columnAndValue -> {
            Row row = (Row)Mockito.mock(Row.class);
            Mockito.when((Object)row.getByteBuffer("key")).thenReturn(tuple._1);
            Mockito.when((Object)row.getByteBuffer("column1")).thenReturn(columnAndValue._1);
            Mockito.when((Object)row.getByteBuffer("value")).thenReturn(columnAndValue._2);
            return row;
        }));
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.iterator()).thenReturn((Object)rows.iterator());
        return resultSet;
    }
}

