/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import java.util.ArrayList;
import org.apache.commons.lang.UnhandledException;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.MultiWriteKeyColumnValueStoreTest;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.CQLStoreManager;
import org.janusgraph.diskstorage.cql.CachingCQLStoreManager;
import org.janusgraph.testutil.TestLoggerUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CQLMultiWriteStoreTest
extends MultiWriteKeyColumnValueStoreTest {
    @Container
    public static final JanusGraphCassandraContainer cqlContainer = new JanusGraphCassandraContainer();

    protected ModifiableConfiguration getBaseStorageConfiguration() {
        return cqlContainer.getConfiguration(((Object)((Object)this)).getClass().getSimpleName());
    }

    private CQLStoreManager openStorageManager(Configuration c) throws BackendException {
        return new CachingCQLStoreManager(c);
    }

    public CQLStoreManager openStorageManager() throws BackendException {
        return this.openStorageManager((Configuration)this.getBaseStorageConfiguration());
    }

    @Test
    public void shouldLogSessionLeakWarning() throws BackendException {
        TestLoggerUtils.processWithLoggerReplacement(logger -> {
            ModifiableConfiguration configuration = this.getBaseStorageConfiguration();
            configuration.set(CQLConfigOptions.SESSION_LEAK_THRESHOLD, (Object)2, new String[0]);
            ListAppender<ILoggingEvent> listAppender = TestLoggerUtils.registerListAppender(logger);
            Assertions.assertFalse((boolean)this.hasWarnLog(listAppender));
            ArrayList<CQLStoreManager> storeManagers = new ArrayList<CQLStoreManager>(3);
            for (int i = 0; i < 3; ++i) {
                try {
                    storeManagers.add(new CQLStoreManager((Configuration)configuration));
                    continue;
                }
                catch (BackendException e) {
                    Assertions.fail();
                }
            }
            Assertions.assertTrue((boolean)this.hasWarnLog(listAppender));
            storeManagers.forEach(cqlStoreManager -> {
                try {
                    cqlStoreManager.close();
                }
                catch (BackendException backendException) {
                    throw new UnhandledException((Throwable)backendException);
                }
            });
        }, DefaultSession.class, Level.WARN);
    }

    @Test
    public void shouldProperlyCloseSessionOnExceptionAndNotLogSessionLeakWarnings() {
        TestLoggerUtils.processWithLoggerReplacement(logger -> {
            ModifiableConfiguration configuration = (ModifiableConfiguration)Mockito.spy((Object)this.getBaseStorageConfiguration());
            configuration.set(CQLConfigOptions.SESSION_LEAK_THRESHOLD, (Object)2, new String[0]);
            ListAppender<ILoggingEvent> listAppender = TestLoggerUtils.registerListAppender(logger);
            ((ModifiableConfiguration)Mockito.doThrow(RuntimeException.class).when((Object)configuration)).get(CQLConfigOptions.BATCH_STATEMENT_SIZE, new String[0]);
            Assertions.assertFalse((boolean)this.hasWarnLog(listAppender));
            for (int i = 0; i < 3; ++i) {
                Assertions.assertThrows(Throwable.class, () -> new CQLStoreManager((Configuration)configuration));
            }
            Assertions.assertFalse((boolean)this.hasWarnLog(listAppender));
        }, DefaultSession.class, Level.WARN);
    }

    private boolean hasWarnLog(ListAppender<ILoggingEvent> listAppender) {
        for (ILoggingEvent logEvent : listAppender.list) {
            if (!Level.WARN.equals(logEvent.getLevel()) || !logEvent.getMessage().startsWith("You have too many session instances")) continue;
            return true;
        }
        return false;
    }
}

