/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import com.google.common.base.Preconditions;
import java.io.File;
import java.time.Duration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.utility.DockerImageName;

public class JanusGraphCassandraContainer
extends CassandraContainer<JanusGraphCassandraContainer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JanusGraphCassandraContainer.class);
    private static final String DEFAULT_VERSION = "3.11.10";
    private static final String DEFAULT_IMAGE = "cassandra";
    private static final String DEFAULT_PARTITIONER = "murmur";
    private static final boolean DEFAULT_USE_SSL = false;
    private static final boolean DEFAULT_ENABLE_CLIENT_AUTH = false;
    private static final boolean DEFAULT_USE_DEFAULT_CONFIG_FROM_IMAGE = false;
    private static final String DEFAULT_STORAGE_BACKEND = "cql";

    private static String getVersion() {
        String property = System.getProperty("cassandra.docker.version");
        if (property != null && !property.isEmpty()) {
            return property;
        }
        return DEFAULT_VERSION;
    }

    private static String getCassandraImage() {
        String property = System.getProperty("cassandra.docker.image");
        if (property != null && !property.isEmpty()) {
            return property;
        }
        return DEFAULT_IMAGE;
    }

    private static String getPartitioner() {
        String property = System.getProperty("cassandra.docker.partitioner");
        if (property != null && !property.isEmpty()) {
            return property;
        }
        return DEFAULT_PARTITIONER;
    }

    private static boolean useDynamicConfig() {
        String property = System.getProperty("cassandra.docker.useDefaultConfigFromImage");
        if (property != null && !property.isEmpty()) {
            return !Boolean.parseBoolean(property);
        }
        return true;
    }

    private static boolean useSSL() {
        String property = System.getProperty("cassandra.docker.useSSL");
        if (property != null && !property.isEmpty()) {
            return Boolean.parseBoolean(property);
        }
        return false;
    }

    private static boolean enableClientAuth() {
        String property = System.getProperty("cassandra.docker.enableClientAuth");
        if (property != null && !property.isEmpty()) {
            return Boolean.parseBoolean(property);
        }
        return false;
    }

    private static String storageBackend() {
        String property = System.getProperty("cql.storageBackend");
        return property == null || property.isEmpty() ? DEFAULT_STORAGE_BACKEND : property;
    }

    private static boolean isScylla() {
        return JanusGraphCassandraContainer.getCassandraImage().contains("scylla");
    }

    public static boolean supportsPerPartitionLimit() {
        if (JanusGraphCassandraContainer.isScylla()) {
            return true;
        }
        String version = JanusGraphCassandraContainer.getVersion();
        int majorVersionEnd = version.indexOf(".");
        if (majorVersionEnd < 1) {
            return false;
        }
        String majorVersionStr = version.substring(0, majorVersionEnd);
        try {
            if (Integer.parseInt(majorVersionStr) > 3) {
                return true;
            }
        }
        catch (Throwable t) {
            return false;
        }
        int minorVersionEnd = version.indexOf(".", majorVersionEnd + 1);
        if (minorVersionEnd == -1) {
            return false;
        }
        String minorVersionStr = version.substring(majorVersionEnd + 1, minorVersionEnd);
        try {
            if (Integer.parseInt(minorVersionStr) >= 11) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
        }
    }

    private String getConfigPrefix() {
        if (JanusGraphCassandraContainer.isScylla()) {
            return "scylla";
        }
        if (JanusGraphCassandraContainer.getVersion().startsWith("3.")) {
            return "cassandra3";
        }
        return "cassandra4";
    }

    public JanusGraphCassandraContainer() {
        this(false);
    }

    public JanusGraphCassandraContainer(boolean bindDefaultPort) {
        super(DockerImageName.parse((String)(JanusGraphCassandraContainer.getCassandraImage() + ":" + JanusGraphCassandraContainer.getVersion())).asCompatibleSubstituteFor(DEFAULT_IMAGE));
        if (bindDefaultPort) {
            this.addFixedExposedPort(CQL_PORT, CQL_PORT);
        }
        this.withEnv("MAX_HEAP_SIZE", "2G");
        this.withEnv("HEAP_NEWSIZE", "1G");
        if (JanusGraphCassandraContainer.useDynamicConfig()) {
            String commandArguments = JanusGraphCassandraContainer.isScylla() ? "--skip-wait-for-gossip-to-settle 0 --memory 2G --smp 1 --developer-mode 1 --max-partition-key-restrictions-per-query 2147483647" : "-Dcassandra.skip_wait_for_gossip_to_settle=0 -Dcassandra.load_ring_state=false";
            this.withCommand(commandArguments);
            switch (JanusGraphCassandraContainer.getPartitioner()) {
                case "byteordered": {
                    this.applyConfiguration(this.getConfigPrefix() + "-byteordered.yaml");
                    break;
                }
                case "murmur": {
                    if (JanusGraphCassandraContainer.useSSL()) {
                        this.withClasspathResourceMapping("cert/node.crt", "/etc/ssl/node.crt", BindMode.READ_WRITE);
                        this.withClasspathResourceMapping("cert/node.key", "/etc/ssl/node.key", BindMode.READ_WRITE);
                        this.withClasspathResourceMapping("cert/node.keystore", "/etc/ssl/node.keystore", BindMode.READ_WRITE);
                        this.withClasspathResourceMapping("cqlshrc", "/root/.cassandra/cqlshrc", BindMode.READ_WRITE);
                        if (JanusGraphCassandraContainer.enableClientAuth()) {
                            this.withClasspathResourceMapping("cert/node.truststore", "/etc/ssl/node.truststore", BindMode.READ_WRITE);
                            this.applyConfiguration(this.getConfigPrefix() + "-murmur-client-auth.yaml");
                            break;
                        }
                        this.applyConfiguration(this.getConfigPrefix() + "-murmur-ssl.yaml");
                        break;
                    }
                    this.applyConfiguration(this.getConfigPrefix() + "-murmur.yaml");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized partitioner: " + JanusGraphCassandraContainer.getPartitioner());
                }
            }
        }
    }

    private void applyConfiguration(String resourcePath) {
        String configPath = JanusGraphCassandraContainer.isScylla() ? "/etc/scylla/scylla.yaml" : "/etc/cassandra/cassandra.yaml";
        this.withClasspathResourceMapping(resourcePath, configPath, BindMode.READ_WRITE);
    }

    private static String cleanKeyspaceName(String raw) {
        Preconditions.checkNotNull((Object)raw);
        Preconditions.checkArgument((0 < raw.length() ? 1 : 0) != 0);
        if (48 < raw.length() || raw.matches("^.*[^a-zA-Z0-9_].*$")) {
            return "strhash" + Math.abs(raw.hashCode());
        }
        return raw;
    }

    public ModifiableConfiguration getConfiguration(String keyspace) {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(CQLConfigOptions.KEYSPACE, (Object)JanusGraphCassandraContainer.cleanKeyspaceName(keyspace), new String[0]);
        LOGGER.debug("Set keyspace name: {}", config.get(CQLConfigOptions.KEYSPACE, new String[0]));
        config.set(GraphDatabaseConfiguration.PAGE_SIZE, (Object)500, new String[0]);
        config.set(GraphDatabaseConfiguration.CONNECTION_TIMEOUT, (Object)Duration.ofSeconds(60L), new String[0]);
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)JanusGraphCassandraContainer.storageBackend(), new String[0]);
        config.set(GraphDatabaseConfiguration.STORAGE_PORT, (Object)this.getMappedPort(CQL_PORT), new String[0]);
        config.set(GraphDatabaseConfiguration.STORAGE_HOSTS, (Object)new String[]{this.getHost()}, new String[0]);
        config.set(GraphDatabaseConfiguration.DROP_ON_CLEAR, (Object)false, new String[0]);
        config.set(CQLConfigOptions.MAX_REQUESTS_PER_CONNECTION, (Object)1024, new String[0]);
        if (JanusGraphCassandraContainer.useDynamicConfig()) {
            if (JanusGraphCassandraContainer.useSSL()) {
                config.set(CQLConfigOptions.SSL_ENABLED, (Object)true, new String[0]);
                config.set(CQLConfigOptions.SSL_TRUSTSTORE_LOCATION, (Object)String.join((CharSequence)File.separator, "target", "test-classes", "cert", "client.truststore"), new String[0]);
                config.set(CQLConfigOptions.SSL_TRUSTSTORE_PASSWORD, (Object)"client", new String[0]);
            }
            if (JanusGraphCassandraContainer.enableClientAuth()) {
                config.set(CQLConfigOptions.SSL_CLIENT_AUTHENTICATION_ENABLED, (Object)true, new String[0]);
                config.set(CQLConfigOptions.SSL_KEYSTORE_LOCATION, (Object)String.join((CharSequence)File.separator, "target", "test-classes", "cert", "client.keystore"), new String[0]);
                config.set(CQLConfigOptions.SSL_KEYSTORE_STORE_PASSWORD, (Object)"client", new String[0]);
                config.set(CQLConfigOptions.SSL_KEYSTORE_KEY_PASSWORD, (Object)"client", new String[0]);
            }
        }
        return config;
    }

    public int getMappedCQLPort() {
        return this.getMappedPort(CQL_PORT);
    }
}

