/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.addedrelations;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.transaction.addedrelations.AddedPropertiesValue;

public class AddedPropertiesListValue
implements AddedPropertiesValue {
    private final LinkedHashSet<InternalRelation> internalRelationSet = new LinkedHashSet(20);

    @Override
    public int addValue(InternalRelation internalRelation) {
        int sizeBefore = this.internalRelationSet.size();
        this.internalRelationSet.add(internalRelation);
        return this.internalRelationSet.size() - sizeBefore;
    }

    @Override
    public int removeValue(InternalRelation internalRelation) {
        int sizeBefore = this.internalRelationSet.size();
        this.internalRelationSet.remove(internalRelation);
        return sizeBefore - this.internalRelationSet.size();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void clear() {
        this.internalRelationSet.clear();
    }

    @Override
    public Iterator<InternalRelation> getView() {
        return Iterators.transform(this.internalRelationSet.iterator(), e -> {
            assert (e != null);
            return e;
        });
    }

    @Override
    public Iterator<InternalRelation> getView(Object value) {
        return Iterables.filter(this::getView, i -> ((JanusGraphVertexProperty)((Object)i)).value().equals(value)).iterator();
    }
}

