/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.graphdb.database.cache.SchemaCache;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.relations.EdgeDirection;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.types.system.BaseLabel;
import org.janusgraph.graphdb.types.system.BaseRelationType;
import org.janusgraph.graphdb.types.system.SystemRelationType;
import org.jctools.maps.NonBlockingHashMapLong;

public class StandardSchemaCache
implements SchemaCache {
    public static final int MAX_CACHED_TYPES_DEFAULT = 10000;
    private static final int INITIAL_CAPACITY = 128;
    private static final int INITIAL_CACHE_SIZE = 16;
    private static final int CACHE_RELATION_MULTIPLIER = 3;
    private static final int CONCURRENCY_LEVEL = 2;
    private static final int SCHEMAID_TOTALFORW_SHIFT = 3;
    private static final int SCHEMAID_BACK_SHIFT = 2;
    private final int maxCachedTypes;
    private final int maxCachedRelations;
    private final SchemaCache.StoreRetrieval retriever;
    private volatile ConcurrentMap<String, Long> typeNames;
    private final Cache<String, Long> typeNamesBackup;
    private volatile ConcurrentMap<Long, EntryList> schemaRelations;
    private final Cache<Long, EntryList> schemaRelationsBackup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StandardSchemaCache(SchemaCache.StoreRetrieval retriever) {
        this(10000, retriever);
    }

    public StandardSchemaCache(int size, SchemaCache.StoreRetrieval retriever) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Size must be positive");
        Preconditions.checkNotNull((Object)retriever);
        this.maxCachedTypes = size;
        this.maxCachedRelations = this.maxCachedTypes * 3;
        this.retriever = retriever;
        this.typeNamesBackup = Caffeine.newBuilder().initialCapacity(16).maximumSize((long)this.maxCachedTypes).build();
        this.typeNames = new ConcurrentHashMap<String, Long>(128, 0.75f, 2);
        this.schemaRelationsBackup = Caffeine.newBuilder().initialCapacity(48).maximumSize((long)this.maxCachedRelations).build();
        this.schemaRelations = new NonBlockingHashMapLong(384);
    }

    @Override
    public Long getSchemaId(String schemaName) {
        Long id;
        ConcurrentMap<String, Long> types = this.typeNames;
        if (types == null) {
            id = (Long)this.typeNamesBackup.getIfPresent((Object)schemaName);
            if (id == null && (id = this.retriever.retrieveSchemaByName(schemaName)) != null) {
                this.typeNamesBackup.put((Object)schemaName, (Object)id);
            }
        } else {
            id = (Long)types.get(schemaName);
            if (id == null) {
                if (types.size() > this.maxCachedTypes) {
                    this.typeNames = null;
                    return this.getSchemaId(schemaName);
                }
                id = this.retriever.retrieveSchemaByName(schemaName);
                if (id != null) {
                    types.put(schemaName, id);
                }
            }
        }
        return id;
    }

    private long getIdentifier(long schemaId, SystemRelationType type, Direction dir) {
        int systemTypeId;
        int edgeDir = EdgeDirection.position(dir);
        if (!$assertionsDisabled && edgeDir != 0 && edgeDir != 1) {
            throw new AssertionError();
        }
        long typeId = schemaId >>> 2;
        if (type == BaseLabel.SchemaDefinitionEdge) {
            systemTypeId = 0;
        } else if (type == BaseKey.SchemaName) {
            systemTypeId = 1;
        } else if (type == BaseKey.SchemaCategory) {
            systemTypeId = 2;
        } else if (type == BaseKey.SchemaDefinitionProperty) {
            systemTypeId = 3;
        } else {
            throw new AssertionError((Object)("Unexpected SystemType encountered in StandardSchemaCache: " + type.name()));
        }
        if (!$assertionsDisabled && systemTypeId >= 4) {
            throw new AssertionError();
        }
        return ((typeId << 2) + (long)systemTypeId << 1) + (long)edgeDir;
    }

    @Override
    public EntryList getSchemaRelations(long schemaId, BaseRelationType type, Direction dir) {
        EntryList entries;
        if (!($assertionsDisabled || IDManager.isSystemRelationTypeId(type.id()) && type.longId() > 0L)) {
            throw new AssertionError();
        }
        Preconditions.checkArgument((boolean)IDManager.VertexIDType.Schema.is(schemaId));
        Preconditions.checkArgument((0x3FFFFFFFFFFFFFFFL >= schemaId ? 1 : 0) != 0);
        int edgeDir = EdgeDirection.position(dir);
        if (!$assertionsDisabled && edgeDir != 0 && edgeDir != 1) {
            throw new AssertionError();
        }
        long typePlusRelation = this.getIdentifier(schemaId, type, dir);
        ConcurrentMap<Long, EntryList> types = this.schemaRelations;
        if (types == null) {
            entries = (EntryList)this.schemaRelationsBackup.getIfPresent((Object)typePlusRelation);
            if (entries == null && !(entries = this.retriever.retrieveSchemaRelations(schemaId, type, dir)).isEmpty()) {
                this.schemaRelationsBackup.put((Object)typePlusRelation, (Object)entries);
            }
        } else {
            entries = (EntryList)types.get(typePlusRelation);
            if (entries == null) {
                if (types.size() > this.maxCachedRelations) {
                    this.schemaRelations = null;
                    return this.getSchemaRelations(schemaId, type, dir);
                }
                entries = this.retriever.retrieveSchemaRelations(schemaId, type, dir);
                types.put(typePlusRelation, entries);
            }
        }
        if (!$assertionsDisabled && entries == null) {
            throw new AssertionError();
        }
        return entries;
    }

    @Override
    public void expireSchemaElement(long schemaId) {
        long cutTypeId = schemaId >>> 2;
        ConcurrentMap<Long, EntryList> types = this.schemaRelations;
        if (types != null) {
            types.keySet().removeIf(key -> key >>> 3 == cutTypeId);
        }
        for (Long key2 : this.schemaRelationsBackup.asMap().keySet()) {
            if (key2 >>> 3 != cutTypeId) continue;
            this.schemaRelationsBackup.invalidate((Object)key2);
        }
        ConcurrentMap<String, Long> names = this.typeNames;
        if (names != null) {
            names.entrySet().removeIf(next -> ((Long)next.getValue()).equals(schemaId));
        }
        for (Map.Entry entry : this.typeNamesBackup.asMap().entrySet()) {
            if (!((Long)entry.getValue()).equals(schemaId)) continue;
            this.typeNamesBackup.invalidate(entry.getKey());
        }
    }

    static {
        boolean bl = $assertionsDisabled = !StandardSchemaCache.class.desiredAssertionStatus();
        if (!$assertionsDisabled && IDManager.VertexIDType.Schema.removePadding(4L) != 1L) {
            throw new AssertionError();
        }
    }
}

