/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core;

import org.janusgraph.core.JanusGraphLazyEdge;
import org.janusgraph.core.JanusGraphLazyRelation;
import org.janusgraph.core.JanusGraphLazyVertexProperty;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.system.BaseRelationType;
import org.janusgraph.graphdb.types.system.SystemRelationType;

public class JanusGraphLazyRelationConstructor {
    public static InternalRelation create(InternalRelation janusGraphRelation, InternalVertex vertex, StandardJanusGraphTx tx) {
        long typeId = janusGraphRelation.getType().longId();
        InternalRelationType type = tx.getOrLoadRelationTypeById(typeId);
        JanusGraphLazyRelation lazyRelation = type.isPropertyKey() ? new JanusGraphLazyVertexProperty(janusGraphRelation, vertex, tx, type) : new JanusGraphLazyEdge(janusGraphRelation, vertex, tx, type);
        if (type instanceof BaseRelationType) {
            return lazyRelation.loadValue();
        }
        return lazyRelation;
    }

    public static InternalRelation create(Entry dataEntry, InternalVertex vertex, StandardJanusGraphTx tx) {
        long typeId = tx.getEdgeSerializer().parseTypeId(dataEntry);
        InternalRelationType type = tx.getOrLoadRelationTypeById(typeId);
        JanusGraphLazyRelation lazyRelation = type.isPropertyKey() ? new JanusGraphLazyVertexProperty(dataEntry, vertex, tx, type) : new JanusGraphLazyEdge(dataEntry, vertex, tx, type);
        if (type instanceof SystemRelationType) {
            return lazyRelation.loadValue();
        }
        return lazyRelation;
    }
}

