/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DropStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.MultiQueryPositions;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphMultiQueryStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphHasStepStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphLocalQueryOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphStepStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueriableStepRegistrationConsumer;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryStrategyRepeatStepMode;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class JanusGraphMultiQueryStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> PRIORS = new HashSet<Class>(Arrays.asList(JanusGraphLocalQueryOptimizerStrategy.class, JanusGraphHasStepStrategy.class, JanusGraphStepStrategy.class));
    private static final JanusGraphMultiQueryStrategy INSTANCE = new JanusGraphMultiQueryStrategy();
    private static final MultiQueriableStepRegistrationConsumer ATTACH_FIRST_LOOP = JanusGraphMultiQueryStep::attachFirstLoopClient;
    private static final MultiQueriableStepRegistrationConsumer ATTACH_SAME_LOOP = JanusGraphMultiQueryStep::attachSameLoopClient;
    private static final MultiQueriableStepRegistrationConsumer ATTACH_NEXT_LOOP = JanusGraphMultiQueryStep::attachNextLoopClient;

    private JanusGraphMultiQueryStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        boolean multiNestedRepeatNextIterationEligible;
        boolean multiNestedRepeatEligible;
        boolean useMultiQuery;
        if (!traversal.getGraph().isPresent() || TraversalHelper.onGraphComputer(traversal) || !TraversalHelper.getStepsOfAssignableClassRecursively(DropStep.class, traversal).isEmpty()) {
            return;
        }
        StandardJanusGraph janusGraph = JanusGraphTraversalUtil.getJanusGraph(traversal);
        if (janusGraph == null) {
            return;
        }
        Optional<StandardJanusGraphTx> tx = JanusGraphTraversalUtil.getJanusGraphTx(traversal);
        boolean bl = useMultiQuery = tx.isPresent() ? tx.get().getConfiguration().useMultiQuery() : janusGraph.getConfiguration().useMultiQuery();
        if (!useMultiQuery) {
            return;
        }
        GraphDatabaseConfiguration graphConfig = janusGraph.getConfiguration();
        boolean limitedBatch = graphConfig.limitedBatch();
        int limitedBatchSize = graphConfig.limitedBatchSize();
        MultiQueryStrategyRepeatStepMode repeatStepMode = graphConfig.repeatStepMode();
        switch (repeatStepMode) {
            case CLOSEST_REPEAT_PARENT: {
                multiNestedRepeatEligible = false;
                multiNestedRepeatNextIterationEligible = false;
                break;
            }
            case ALL_REPEAT_PARENTS: {
                multiNestedRepeatEligible = true;
                multiNestedRepeatNextIterationEligible = true;
                break;
            }
            case STARTS_ONLY_OF_ALL_REPEAT_PARENTS: {
                multiNestedRepeatEligible = true;
                multiNestedRepeatNextIterationEligible = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unimplemented `repeat` step mode " + repeatStepMode.getConfigName());
            }
        }
        this.insertMultiQuerySteps(traversal, limitedBatch, limitedBatchSize);
        this.configureMultiQueriables(traversal, limitedBatch, limitedBatchSize, multiNestedRepeatEligible, multiNestedRepeatNextIterationEligible);
    }

    private void insertMultiQuerySteps(Traversal.Admin<?, ?> traversal, boolean limitedBatch, int limitedBatchSize) {
        JanusGraphTraversalUtil.getSteps(step -> step instanceof MultiQueriable || step instanceof TraversalParent, traversal).forEach(step -> {
            Optional<Step> multiQueryPosition = JanusGraphTraversalUtil.getLocalMultiQueryPositionForStep(step);
            if (multiQueryPosition.isPresent() && JanusGraphTraversalUtil.isLegalMultiQueryPosition(multiQueryPosition.get())) {
                this.insertMultiQueryStep(multiQueryPosition.get(), limitedBatch, limitedBatchSize);
            }
            if (step instanceof RepeatStep) {
                this.insertMultiQueryStepToTraversalEnd(((RepeatStep)step).getRepeatTraversal(), limitedBatch, limitedBatchSize);
            }
        });
    }

    private void insertMultiQueryStep(Step position, boolean limitedBatch, int limitedBatchSize) {
        JanusGraphMultiQueryStep multiQueryStep;
        Traversal.Admin traversal = position.getTraversal();
        if (limitedBatch) {
            if (position instanceof NoOpBarrierStep) {
                multiQueryStep = new JanusGraphMultiQueryStep(traversal, limitedBatch, ((NoOpBarrierStep)position).getMaxBarrierSize());
            } else {
                NoOpBarrierStep barrier = new NoOpBarrierStep(traversal, limitedBatchSize);
                TraversalHelper.insertBeforeStep((Step)barrier, (Step)position, (Traversal.Admin)traversal);
                position = barrier;
                multiQueryStep = new JanusGraphMultiQueryStep(traversal, limitedBatch, barrier);
            }
        } else {
            multiQueryStep = new JanusGraphMultiQueryStep(traversal, limitedBatch);
        }
        TraversalHelper.insertBeforeStep((Step)multiQueryStep, (Step)position, (Traversal.Admin)traversal);
    }

    private void insertMultiQueryStepToTraversalEnd(Traversal.Admin traversal, boolean limitedBatch, int limitedBatchSize) {
        Optional<Step> optionalRepeatEndMultiQueryPosition = JanusGraphTraversalUtil.getEndMultiQueryPosition(traversal);
        if (!optionalRepeatEndMultiQueryPosition.isPresent()) {
            return;
        }
        Step currentStep = optionalRepeatEndMultiQueryPosition.get();
        this.insertMultiQueryStep(currentStep, limitedBatch, limitedBatchSize);
    }

    private void configureMultiQueriables(Traversal.Admin<?, ?> traversal, boolean limitedBatch, int limitedBatchSize, boolean multiNestedRepeatEligible, boolean multiNestedRepeatNextIterationEligible) {
        TraversalHelper.getStepsOfAssignableClass(MultiQueriable.class, traversal).forEach(multiQueriable -> {
            MultiQueryPositions multiQueryPositions = JanusGraphTraversalUtil.getAllMultiQueryPositionsForMultiQueriable(multiQueriable, multiNestedRepeatEligible, multiNestedRepeatNextIterationEligible);
            if (this.hasIllegalPositions(multiQueryPositions)) {
                return;
            }
            boolean barrierSizeSet = !limitedBatch;
            for (Step mqPos : multiQueryPositions.currentLoopMultiQueryStepLocations) {
                if (!this.applyPreviousMultiQueryAndReturnIfBarrierSizeSet((MultiQueriable)multiQueriable, mqPos, barrierSizeSet, ATTACH_SAME_LOOP)) continue;
                barrierSizeSet = true;
            }
            if (multiQueryPositions.nextLoopMultiQueryStepLocation != null && this.applyPreviousMultiQueryAndReturnIfBarrierSizeSet((MultiQueriable)multiQueriable, multiQueryPositions.nextLoopMultiQueryStepLocation, barrierSizeSet, ATTACH_NEXT_LOOP)) {
                barrierSizeSet = true;
            }
            for (Step mqPos : multiQueryPositions.firstLoopMultiQueryStepLocations) {
                if (!this.applyPreviousMultiQueryAndReturnIfBarrierSizeSet((MultiQueriable)multiQueriable, mqPos, barrierSizeSet, ATTACH_FIRST_LOOP)) continue;
                barrierSizeSet = true;
            }
            if (!barrierSizeSet) {
                multiQueriable.setBatchSize(limitedBatchSize);
            }
            if (!multiQueryPositions.currentLoopMultiQueryStepLocations.isEmpty() || !multiQueryPositions.firstLoopMultiQueryStepLocations.isEmpty() || multiQueryPositions.nextLoopMultiQueryStepLocation != null) {
                multiQueriable.setUseMultiQuery(true);
            }
        });
    }

    private boolean applyPreviousMultiQueryAndReturnIfBarrierSizeSet(MultiQueriable multiQueriableStep, Step multiQueryPositionStep, boolean barrierSizeSet, MultiQueriableStepRegistrationConsumer attachClientConsumer) {
        Optional<JanusGraphMultiQueryStep> optionalMultiQueryStep = JanusGraphTraversalUtil.getPreviousStepOfClass(JanusGraphMultiQueryStep.class, multiQueryPositionStep);
        if (optionalMultiQueryStep.isPresent()) {
            JanusGraphMultiQueryStep multiQueryStep = optionalMultiQueryStep.get();
            attachClientConsumer.attachClient(multiQueryStep, multiQueriableStep);
            if (!barrierSizeSet) {
                Optional<Integer> localSetBatchSize = JanusGraphTraversalUtil.getLocalNonMultiQueryProvidedBatchSize(multiQueriableStep);
                if (localSetBatchSize.isPresent()) {
                    multiQueriableStep.setBatchSize(localSetBatchSize.get());
                    return true;
                }
                Optional<Integer> optionalRelatedBarrierStepSize = multiQueryStep.getRelatedBarrierStepSize();
                if (optionalRelatedBarrierStepSize.isPresent()) {
                    multiQueriableStep.setBatchSize(optionalRelatedBarrierStepSize.get());
                    return true;
                }
            }
        }
        return false;
    }

    boolean hasIllegalPositions(MultiQueryPositions multiQueryPositions) {
        if (multiQueryPositions.nextLoopMultiQueryStepLocation != null && !JanusGraphTraversalUtil.isLegalMultiQueryPosition(multiQueryPositions.nextLoopMultiQueryStepLocation)) {
            return true;
        }
        for (Step mqPos : multiQueryPositions.currentLoopMultiQueryStepLocations) {
            if (JanusGraphTraversalUtil.isLegalMultiQueryPosition(mqPos)) continue;
            return true;
        }
        for (Step mqPos : multiQueryPositions.firstLoopMultiQueryStepLocations) {
            if (JanusGraphTraversalUtil.isLegalMultiQueryPosition(mqPos)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return PRIORS;
    }

    public static JanusGraphMultiQueryStrategy instance() {
        return INSTANCE;
    }
}

