/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertyMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.WithOptions;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.PropertyType;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.LabelStepBatchFetcher;
import org.janusgraph.graphdb.tinkerpop.optimize.step.service.DirectPropertiesFetchingService;
import org.janusgraph.graphdb.tinkerpop.optimize.step.service.PropertiesFetchingService;
import org.janusgraph.graphdb.tinkerpop.optimize.step.service.TraversalPropertiesFetchingService;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;
import org.janusgraph.graphdb.util.CopyStepUtil;
import org.janusgraph.graphdb.util.JanusGraphTraverserUtil;

public class JanusGraphPropertyMapStep<K, E>
extends PropertyMapStep<K, E>
implements Profiling,
MultiQueriable<Element, Map<K, E>> {
    private boolean useMultiQuery = false;
    private LabelStepBatchFetcher labelStepBatchFetcher;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private int batchSize = Integer.MAX_VALUE;
    private boolean withIdsFetching;
    private boolean withLabelsFetching;
    private final boolean prefetchAllPropertiesRequired;
    private final boolean prefetchingAllowed;
    private PropertiesFetchingService propertiesFetchingService;
    private final boolean isReturnTypeValue;

    public JanusGraphPropertyMapStep(PropertyMapStep<K, E> originalStep, boolean prefetchAllPropertiesRequired, boolean prefetchingAllowed) {
        super(originalStep.getTraversal(), originalStep.getReturnType(), originalStep.getTraversalRing(), originalStep.getPropertyKeys());
        CopyStepUtil.copyAbstractStepModifiableFields(originalStep, this);
        this.prefetchAllPropertiesRequired = prefetchAllPropertiesRequired;
        this.prefetchingAllowed = prefetchingAllowed;
        this.isReturnTypeValue = this.getReturnType() == PropertyType.VALUE;
        this.tokens = originalStep.getIncludedTokens();
        this.withIdsFetching = this.includeToken(WithOptions.ids);
        this.withLabelsFetching = this.includeToken(WithOptions.labels);
        this.traversalRing.getTraversals().forEach(arg_0 -> ((JanusGraphPropertyMapStep)this).integrateChild(arg_0));
        this.parameters = originalStep.getParameters();
        this.parameters.getTraversals().forEach(arg_0 -> ((JanusGraphPropertyMapStep)this).integrateChild(arg_0));
        Traversal.Admin propertyTraversal = originalStep.getPropertyTraversal();
        if (propertyTraversal != null) {
            super.setPropertyTraversal(propertyTraversal);
        }
        if (originalStep instanceof JanusGraphPropertyMapStep) {
            JanusGraphPropertyMapStep originalJanusGraphPropertyMapStep = (JanusGraphPropertyMapStep)originalStep;
            this.setBatchSize(originalJanusGraphPropertyMapStep.batchSize);
            this.setUseMultiQuery(originalJanusGraphPropertyMapStep.useMultiQuery);
        }
    }

    public void configure(Object ... keyValues) {
        super.configure(keyValues);
        this.withIdsFetching = this.includeToken(WithOptions.ids);
        this.withLabelsFetching = this.includeToken(WithOptions.labels);
        this.createLabelFetcherIfNeeded();
    }

    public void setPropertyTraversal(Traversal.Admin<Element, ? extends Property> propertyTraversal) {
        super.setPropertyTraversal(propertyTraversal);
        this.propertiesFetchingService = null;
        this.setUseMultiQuery(this.useMultiQuery);
    }

    protected Map<K, E> map(Traverser.Admin<Element> traverser) {
        if (this.useMultiQuery && traverser.get() instanceof Vertex) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            this.addElementPropertiesInternal(traverser, map);
            this.addIncludedOptions(map, traverser);
            this.applyTraversalRingToMap(map);
            return map;
        }
        return super.map(traverser);
    }

    private void addElementPropertiesInternal(Traverser.Admin<Element> traverser, Map<Object, Object> map) {
        Iterator<? extends Property> properties = this.propertiesFetchingService.fetchProperties(traverser, this.traversal);
        while (properties.hasNext()) {
            Property property = properties.next();
            Object value = this.isReturnTypeValue ? property.value() : property;
            map.compute(property.key(), (k, v) -> {
                List values = v != null ? (List)v : new ArrayList();
                values.add(value);
                return values;
            });
        }
    }

    private void addIncludedOptions(Map<Object, Object> map, Traverser.Admin<Element> traverser) {
        if (this.returnType == PropertyType.VALUE) {
            Vertex vertexToFetch = (Vertex)traverser.get();
            if (this.withIdsFetching) {
                map.put(T.id, this.getElementId((Element)vertexToFetch));
            }
            if (this.withLabelsFetching) {
                map.put(T.label, this.labelStepBatchFetcher.fetchData(this.getTraversal(), vertexToFetch, JanusGraphTraverserUtil.getLoops(traverser)));
            }
        }
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
        if (this.propertiesFetchingService instanceof DirectPropertiesFetchingService) {
            ((DirectPropertiesFetchingService)this.propertiesFetchingService).setQueryProfiler(this.queryProfiler);
        } else if (this.propertiesFetchingService != null) {
            this.propertiesFetchingService.setMetrics(metrics);
        }
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        boolean bl = this.useMultiQuery = this.prefetchingAllowed && useMultiQuery;
        if (this.useMultiQuery && this.propertiesFetchingService == null) {
            Traversal.Admin propertyTraversal = this.getPropertyTraversal();
            this.propertiesFetchingService = propertyTraversal == null ? new DirectPropertiesFetchingService(this.getPropertyKeys(), this.batchSize, this.prefetchAllPropertiesRequired, this.queryProfiler) : new TraversalPropertiesFetchingService((Traversal.Admin<Element, ? extends Property>)propertyTraversal, this.batchSize, this.prefetchAllPropertiesRequired);
        }
        this.createLabelFetcherIfNeeded();
    }

    private void createLabelFetcherIfNeeded() {
        if (this.withLabelsFetching && this.useMultiQuery && this.labelStepBatchFetcher == null) {
            this.labelStepBatchFetcher = new LabelStepBatchFetcher(this::makeLabelsQuery, this.batchSize);
        }
    }

    private <Q extends BaseVertexQuery> Q makeLabelsQuery(Q query) {
        return BasicVertexCentricQueryUtil.withLabelVertices((BasicVertexCentricQueryBuilder)query).profiler(this.queryProfiler);
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        if (this.propertiesFetchingService != null) {
            this.propertiesFetchingService.setBatchSize(batchSize);
        }
        if (this.labelStepBatchFetcher != null) {
            this.labelStepBatchFetcher.setBatchSize(batchSize);
        }
    }

    @Override
    public void registerFirstNewLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.propertiesFetchingService.registerFirstNewLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
            if (this.withLabelsFetching) {
                this.labelStepBatchFetcher.registerFirstNewLoopFutureVertexForPrefetching(futureVertex);
            }
        }
    }

    @Override
    public void registerSameLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.propertiesFetchingService.registerSameLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
            if (this.withLabelsFetching) {
                this.labelStepBatchFetcher.registerCurrentLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
            }
        }
    }

    @Override
    public void registerNextLoopFutureVertexForPrefetching(Vertex futureVertex, int futureVertexTraverserLoop) {
        if (this.useMultiQuery) {
            this.propertiesFetchingService.registerNextLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
            if (this.withLabelsFetching) {
                this.labelStepBatchFetcher.registerNextLoopFutureVertexForPrefetching(futureVertex, futureVertexTraverserLoop);
            }
        }
    }
}

