/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.relations;

import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.Direction;

public class RelationCache
implements Iterable<LongObjectCursor<Object>> {
    private static final LongObjectHashMap<Object> EMPTY = new LongObjectHashMap(0);
    public final Direction direction;
    public final long typeId;
    public final long relationId;
    private final Object other;
    private final LongObjectHashMap<Object> properties;

    public RelationCache(Direction direction, long typeId, long relationId, Object other, LongObjectHashMap<Object> properties) {
        this.direction = direction;
        this.typeId = typeId;
        this.relationId = relationId;
        this.other = other;
        this.properties = properties == null || properties.size() > 0 ? properties : EMPTY;
    }

    public RelationCache(Direction direction, long typeId, long relationId, Object other) {
        this(direction, typeId, relationId, other, null);
    }

    public <O> O get(long key) {
        return (O)this.properties.get(key);
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public int numProperties() {
        return this.properties.size();
    }

    public Object getValue() {
        return this.other;
    }

    public Object getOtherVertexId() {
        return this.other;
    }

    public Iterator<LongObjectCursor<Object>> propertyIterator() {
        return this.properties.iterator();
    }

    @Override
    public Iterator<LongObjectCursor<Object>> iterator() {
        return this.propertyIterator();
    }

    public String toString() {
        return this.typeId + "-" + this.direction + "->" + this.other + ":" + this.relationId;
    }
}

