/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.VertexList;
import org.janusgraph.graphdb.query.vertex.VertexIdList;
import org.janusgraph.graphdb.query.vertex.VertexListInternal;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.util.IDUtils;
import org.janusgraph.util.datastructures.IterablesUtil;

public class VertexArrayList
implements VertexListInternal {
    public static final Comparator<JanusGraphVertex> VERTEX_ID_COMPARATOR = (x, y) -> IDUtils.compare((Object)x.id(), (Object)y.id());
    private final StandardJanusGraphTx tx;
    private List<JanusGraphVertex> vertices;
    private boolean sorted;

    private VertexArrayList(StandardJanusGraphTx tx, List<JanusGraphVertex> vertices, boolean sorted) {
        Preconditions.checkArgument((tx != null && vertices != null ? 1 : 0) != 0);
        this.tx = tx;
        this.vertices = vertices;
        this.sorted = sorted;
    }

    public VertexArrayList(StandardJanusGraphTx tx) {
        Preconditions.checkNotNull((Object)tx);
        this.tx = tx;
        this.vertices = new ArrayList<JanusGraphVertex>();
        this.sorted = true;
    }

    @Override
    public void add(JanusGraphVertex n) {
        if (!this.vertices.isEmpty()) {
            this.sorted = this.sorted && IDUtils.compare((Object)this.vertices.get(this.vertices.size() - 1).id(), (Object)n.id()) <= 0;
        }
        this.vertices.add(n);
    }

    @Override
    public Object getID(int pos) {
        return this.vertices.get(pos).id();
    }

    @Override
    public List<Object> getIDs() {
        return VertexArrayList.toIdList(this.vertices);
    }

    @Override
    public JanusGraphVertex get(int pos) {
        return this.vertices.get(pos);
    }

    @Override
    public void sort() {
        if (this.sorted) {
            return;
        }
        this.vertices.sort(VERTEX_ID_COMPARATOR);
        this.sorted = true;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public VertexList subList(int fromPosition, int length) {
        return new VertexArrayList(this.tx, this.vertices.subList(fromPosition, fromPosition + length), this.sorted);
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    @Override
    public void addAll(VertexList vertexlist) {
        VertexArrayList other;
        Preconditions.checkArgument((boolean)(vertexlist instanceof VertexArrayList), (Object)"Only supporting union of identical lists.");
        VertexArrayList vertexArrayList = other = vertexlist instanceof VertexArrayList ? (VertexArrayList)vertexlist : ((VertexIdList)vertexlist).toVertexArrayList();
        if (this.sorted && other.isSorted()) {
            this.vertices = IterablesUtil.mergeSort(this.vertices, other.vertices, VERTEX_ID_COMPARATOR);
        } else {
            this.sorted = false;
            this.vertices.addAll(other.vertices);
        }
    }

    public VertexIdList toVertexLongList() {
        List<Object> list = VertexArrayList.toIdList(this.vertices);
        return new VertexIdList(this.tx, list, this.sorted);
    }

    @Override
    public Iterator<JanusGraphVertex> iterator() {
        return Iterators.unmodifiableIterator(this.vertices.iterator());
    }

    private static List<Object> toIdList(List<JanusGraphVertex> vertices) {
        ArrayList<Object> result = new ArrayList<Object>(vertices.size());
        for (JanusGraphVertex n : vertices) {
            result.add(n.id());
        }
        return result;
    }
}

