/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeOtherVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphLocalQueryOptimizerStrategy;

public abstract class AdjacentVertexOptimizerStrategy<T extends FilterStep<?>>
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy>
implements TraversalStrategy.ProviderOptimizationStrategy {
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> POSTS = Collections.singleton(JanusGraphLocalQueryOptimizerStrategy.class);

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPost() {
        return POSTS;
    }

    protected void optimizeStep(T step) {
        OptimizablePosition pos = this.getOptimizablePosition(step);
        if (pos != OptimizablePosition.NONE && this.isValidStep(step)) {
            this.replaceSequence(step, pos);
        }
    }

    protected abstract boolean isValidStep(T var1);

    private OptimizablePosition getOptimizablePosition(T originalStep) {
        Step predecessor = originalStep.getPreviousStep();
        if (predecessor instanceof NoOpBarrierStep) {
            predecessor = predecessor.getPreviousStep();
        }
        if (predecessor instanceof VertexStep) {
            if (((VertexStep)predecessor).returnsVertex()) {
                return OptimizablePosition.V2V_ID;
            }
            return OptimizablePosition.NONE;
        }
        Step prePredecessor = predecessor.getPreviousStep();
        if (prePredecessor instanceof NoOpBarrierStep) {
            prePredecessor = prePredecessor.getPreviousStep();
        }
        if ((predecessor instanceof EdgeVertexStep || predecessor instanceof EdgeOtherVertexStep) && prePredecessor instanceof VertexStep && ((VertexStep)prePredecessor).returnsEdge()) {
            return OptimizablePosition.V2E_E2V_ID;
        }
        return OptimizablePosition.NONE;
    }

    private void replaceSequence(T originalStep, OptimizablePosition pos) {
        switch (pos) {
            case V2E_E2V_ID: {
                this.replaceSequenceV2EthenE2VthenID(originalStep);
                break;
            }
            case V2V_ID: {
                this.replaceSequenceV2VthenID(originalStep);
                break;
            }
        }
    }

    private void replaceSequenceV2EthenE2VthenID(T originalStep) {
        Traversal.Admin traversal = originalStep.getTraversal();
        if (originalStep.getPreviousStep() instanceof NoOpBarrierStep) {
            traversal.removeStep(originalStep.getPreviousStep());
        }
        Step e2vStep = originalStep.getPreviousStep();
        originalStep.getLabels().forEach(arg_0 -> ((Step)e2vStep).addLabel(arg_0));
        traversal.removeStep(originalStep);
        FilterStep<Edge> filterByAdjacentIdStep = this.makeFilterByAdjacentIdStep(traversal, originalStep);
        TraversalHelper.insertBeforeStep(filterByAdjacentIdStep, (Step)e2vStep, (Traversal.Admin)traversal);
        Step v2eStep = filterByAdjacentIdStep.getPreviousStep();
        while (v2eStep instanceof NoOpBarrierStep) {
            Step barrierStep = v2eStep;
            v2eStep = barrierStep.getPreviousStep();
            traversal.removeStep(barrierStep);
        }
    }

    private void replaceSequenceV2VthenID(T originalStep) {
        Traversal.Admin traversal = originalStep.getTraversal();
        if (originalStep.getPreviousStep() instanceof NoOpBarrierStep) {
            traversal.removeStep(originalStep.getPreviousStep());
        }
        VertexStep v2vStep = (VertexStep)originalStep.getPreviousStep();
        String[] edgeLabels = v2vStep.getEdgeLabels();
        Direction v2vDirection = v2vStep.getDirection();
        VertexStep v2eStep = new VertexStep(traversal, Edge.class, v2vDirection, edgeLabels);
        Object e2vStep = v2vDirection == Direction.BOTH ? new EdgeOtherVertexStep(traversal) : new EdgeVertexStep(traversal, v2vDirection.opposite());
        originalStep.getLabels().forEach(arg_0 -> ((Step)e2vStep).addLabel(arg_0));
        Step predecessor = v2vStep.getPreviousStep();
        traversal.removeStep(originalStep);
        traversal.removeStep((Step)v2vStep);
        FilterStep<Edge> filterByAdjacentIdStep = this.makeFilterByAdjacentIdStep(traversal, originalStep);
        TraversalHelper.insertAfterStep((Step)v2eStep, (Step)predecessor, (Traversal.Admin)traversal);
        TraversalHelper.insertAfterStep(filterByAdjacentIdStep, (Step)v2eStep, (Traversal.Admin)traversal);
        TraversalHelper.insertAfterStep((Step)e2vStep, filterByAdjacentIdStep, (Traversal.Admin)traversal);
    }

    protected abstract FilterStep<Edge> makeFilterByAdjacentIdStep(Traversal.Admin<?, ?> var1, T var2);

    protected static enum OptimizablePosition {
        NONE,
        V2V_ID,
        V2E_E2V_ID;

    }
}

