/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.vertexcache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.transaction.vertexcache.VertexCache;
import org.janusgraph.graphdb.vertices.AbstractVertex;
import org.janusgraph.util.datastructures.Retriever;
import org.jctools.maps.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineVertexCache
implements VertexCache {
    private static final Logger log = LoggerFactory.getLogger(CaffeineVertexCache.class);
    private final ConcurrentMap<Object, InternalVertex> volatileVertices;
    private final Cache<Object, InternalVertex> cache;
    private final long createdTime;

    public CaffeineVertexCache(long maxCacheSize, int initialDirtySize) {
        this.volatileVertices = new NonBlockingHashMap(initialDirtySize);
        log.debug("Created dirty vertex map with initial size {}", (Object)initialDirtySize);
        Caffeine cacheBuilder = Caffeine.newBuilder().maximumSize(maxCacheSize).removalListener((key, v, removalCause) -> {
            if (removalCause == RemovalCause.EXPLICIT) {
                assert (this.volatileVertices.isEmpty());
                return;
            }
            assert (removalCause == RemovalCause.SIZE || removalCause == RemovalCause.REPLACED) : "Cause: " + removalCause;
            if (((AbstractVertex)v).isTxOpen() && (v.isModified() || v.isRemoved())) {
                this.volatileVertices.putIfAbsent(key, (InternalVertex)v);
            }
        }).executor(Runnable::run);
        if (log.isDebugEnabled()) {
            cacheBuilder = cacheBuilder.recordStats();
        }
        this.cache = cacheBuilder.build();
        log.debug("Created vertex cache with max size {}", (Object)maxCacheSize);
        this.createdTime = System.currentTimeMillis();
    }

    @Override
    public boolean contains(Object id) {
        return this.cache.getIfPresent(id) != null || this.volatileVertices.containsKey(id);
    }

    @Override
    public InternalVertex get(Object id, Retriever<Object, InternalVertex> retriever) {
        InternalVertex vertex = (InternalVertex)this.cache.getIfPresent(id);
        if (vertex == null) {
            InternalVertex newVertex = (InternalVertex)this.volatileVertices.get(id);
            if (newVertex == null) {
                newVertex = retriever.get(id);
            }
            assert (newVertex != null);
            InternalVertex v = newVertex;
            try {
                vertex = (InternalVertex)this.cache.get(id, k -> v);
            }
            catch (Exception e) {
                throw new AssertionError((Object)("Should not happen: " + e.getMessage()));
            }
            assert (vertex != null);
        }
        return vertex;
    }

    @Override
    public void add(InternalVertex vertex, Object id) {
        Preconditions.checkNotNull((Object)vertex);
        Preconditions.checkArgument((!(id instanceof Number) || (Long)id != 0L ? 1 : 0) != 0);
        this.cache.put(id, (Object)vertex);
        if (vertex.isNew() || vertex.hasAddedRelations()) {
            this.volatileVertices.put(id, vertex);
        }
    }

    @Override
    public List<InternalVertex> getAllNew() {
        ArrayList<InternalVertex> vertices = new ArrayList<InternalVertex>(10);
        for (InternalVertex v : this.volatileVertices.values()) {
            if (!v.isNew()) continue;
            vertices.add(v);
        }
        return vertices;
    }

    @Override
    public synchronized void close() {
        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            CacheStats stats = this.cache.stats();
            log.debug("Caffeine cache (lifespan: {}ms) stats: {}", (Object)(end - this.createdTime), (Object)stats);
        }
        this.volatileVertices.clear();
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }
}

